/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common.olcserver;

import com.google.common.flogger.FluentLogger;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import io.grpc.Status;
import java.nio.file.Path;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ServerHeapDumpFileDetector {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final LocalFileUtil localFileUtil;
    private final Object olcInfoLock = new Object();
    @GuardedBy(value="olcInfoLock")
    private Long olcProcessId = null;
    @GuardedBy(value="olcInfoLock")
    private String olcServerWorkingDir = null;

    @Inject
    ServerHeapDumpFileDetector(LocalFileUtil localFileUtil) {
        this.localFileUtil = localFileUtil;
    }

    public void detectHeapDumpExistenceWithGrpcError(GrpcExceptionWithErrorId e) {
        if (!e.getUnderlyingRpcException().getStatus().getCode().equals((Object)Status.Code.INTERNAL)) {
            this.detectHeapDumpExistence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectHeapDumpExistence() {
        Object object = this.olcInfoLock;
        synchronized (object) {
            if (this.olcServerWorkingDir == null || this.olcProcessId == null) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Skip checking heap dump existence because no existing OLC server is recorded.");
                return;
            }
            if (!this.localFileUtil.isFileOrDirExist(this.olcServerWorkingDir)) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Skip checking heap dump existence because the working directory of OLC server is not found.");
                return;
            }
            Path heapDumpPath = Path.of(this.olcServerWorkingDir, "java_pid" + this.olcProcessId + ".hprof");
            if (this.localFileUtil.isFileOrDirExist(heapDumpPath)) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Detected OOM heap dump file from OLC server with pid [%s]. Please refer to the heap dump file [%s] and attach it when reporting the issue.", (Object)this.olcProcessId, (Object)heapDumpPath);
                this.olcServerWorkingDir = null;
                this.olcProcessId = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOlcServerInfo(long olcProcessId, String olcServerWorkingDir) {
        Object object = this.olcInfoLock;
        synchronized (object) {
            this.olcProcessId = olcProcessId;
            this.olcServerWorkingDir = olcServerWorkingDir;
        }
    }
}

