/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common.olcserver;

import com.google.auto.value.AutoValue;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.AutoValue_ServerEnvironmentPreparer_ServerEnvironment;
import java.nio.file.Path;

public interface ServerEnvironmentPreparer {
    public ServerEnvironment prepareServerEnvironment() throws MobileHarnessException, InterruptedException;

    public static class NoOpServerEnvironmentPreparer
    implements ServerEnvironmentPreparer {
        private final ServerEnvironment serverEnvironment;

        public NoOpServerEnvironmentPreparer(ServerEnvironment serverEnvironment) {
            this.serverEnvironment = serverEnvironment;
        }

        @Override
        public ServerEnvironment prepareServerEnvironment() {
            return this.serverEnvironment;
        }
    }

    @AutoValue
    public static abstract class ServerEnvironment {
        public abstract Path serverBinary();

        public abstract Path javaBinary();

        public abstract Path serverWorkingDir();

        public static ServerEnvironment of(Path serverBinary, Path javaBinary, Path serverWorkingDir) {
            return new AutoValue_ServerEnvironmentPreparer_ServerEnvironment(serverBinary, javaBinary, serverWorkingDir);
        }
    }
}

