/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common;

import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.inject.Inject;

public class XtsTypeLoader {
    public static final String XTS_TYPE_PROPERTY_KEY = "XTS_TYPE";
    private static final String ANDROID_XTS_DIR_NAME_PREFIX = "android-";
    private final LocalFileUtil localFileUtil;

    @Inject
    XtsTypeLoader(LocalFileUtil localFileUtil) {
        this.localFileUtil = localFileUtil;
    }

    public String getXtsType(String xtsRootDir, Supplier<String> helpMessageForMultipleXtsDirs) {
        ImmutableList xtsDirs;
        if (xtsRootDir.isEmpty()) {
            throw new IllegalStateException("XTS root directory is empty.");
        }
        if (!this.localFileUtil.isDirExist(xtsRootDir)) {
            throw new IllegalStateException(String.format("XTS root directory [%s] doesn't exist.", xtsRootDir));
        }
        try {
            xtsDirs = this.localFileUtil.listDirs(Path.of(xtsRootDir, new String[0])).stream().filter(p -> p.getFileName().toString().startsWith(ANDROID_XTS_DIR_NAME_PREFIX)).collect(ImmutableList.toImmutableList());
        }
        catch (MobileHarnessException e) {
            throw new IllegalStateException(e);
        }
        if (xtsDirs.isEmpty()) {
            throw new IllegalStateException(String.format("Android XTS directory whose name is in format [android-<xts>] doesn't exist under directory %s", xtsRootDir));
        }
        if (xtsDirs.size() > 1) {
            throw new IllegalStateException(String.format("Multiple Android XTS directories whose name are in format [android-<xts>] exist under directory %s. dirs=%s. %s", xtsRootDir, xtsDirs, helpMessageForMultipleXtsDirs.get()));
        }
        Path xtsDir = (Path)xtsDirs.get(0);
        return xtsDir.getFileName().toString().substring(ANDROID_XTS_DIR_NAME_PREFIX.length());
    }
}

