/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.converter;

import com.google.devtools.common.metrics.stability.model.ErrorId;
import com.google.devtools.common.metrics.stability.model.proto.ErrorTypeProto;
import com.google.devtools.common.metrics.stability.model.proto.NamespaceProto;
import com.google.devtools.common.metrics.stability.util.ErrorIdFormatter;
import java.util.Objects;

public class UnknownErrorId
implements ErrorId {
    private final int code;
    private final String name;
    private final ErrorTypeProto.ErrorType type;
    private final NamespaceProto.Namespace namespace;
    public static final ErrorId NOT_DEFINED = new UnknownErrorId(-1, "UNKNOWN_ERROR_ID", ErrorTypeProto.ErrorType.UNCLASSIFIED, NamespaceProto.Namespace.UNKNOWN);

    private UnknownErrorId(int code, String name, ErrorTypeProto.ErrorType type, NamespaceProto.Namespace namespace) {
        this.code = code;
        this.name = name;
        this.type = type;
        this.namespace = namespace;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ErrorTypeProto.ErrorType type() {
        return this.type;
    }

    @Override
    public NamespaceProto.Namespace namespace() {
        return this.namespace;
    }

    public String toString() {
        return ErrorIdFormatter.formatErrorId(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorId)) {
            return false;
        }
        ErrorId that = (ErrorId)o;
        return this.code == that.code() && Objects.equals(this.name, that.name()) && this.type == that.type() && this.namespace == that.namespace();
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name, this.type, this.namespace);
    }
}

