/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.auto.common.MoreStreams;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.base.Equivalence;
import autovalue.shaded.com.google.common.base.Preconditions;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.google.auto.value.processor.EclipseHack;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

final class TypeVariables {
    private TypeVariables() {
    }

    static ImmutableMap<ExecutableElement, TypeMirror> rewriteReturnTypes(Elements elementUtils, Types typeUtils, Collection<ExecutableElement> methods, TypeElement sourceType, TypeElement targetType) {
        List<? extends TypeParameterElement> sourceTypeParameters = sourceType.getTypeParameters();
        List<? extends TypeParameterElement> targetTypeParameters = targetType.getTypeParameters();
        Preconditions.checkArgument(sourceTypeParameters.toString().equals(targetTypeParameters.toString()), "%s != %s", sourceTypeParameters, targetTypeParameters);
        EclipseHack eclipseHack = new EclipseHack(elementUtils, typeUtils);
        TypeMirror[] targetTypeParameterMirrors = new TypeMirror[targetTypeParameters.size()];
        for (int i = 0; i < targetTypeParameters.size(); ++i) {
            targetTypeParameterMirrors[i] = targetTypeParameters.get(i).asType();
        }
        DeclaredType parallelSource = typeUtils.getDeclaredType(sourceType, targetTypeParameterMirrors);
        return methods.stream().collect(MoreStreams.toImmutableMap(m4 -> m4, m4 -> eclipseHack.methodReturnType((ExecutableElement)m4, parallelSource)));
    }

    static boolean canAssignStaticMethodResult(ExecutableElement method, TypeMirror actualParameterType, TypeMirror targetType, Types typeUtils) {
        WildcardType wildcard;
        if (!targetType.getKind().equals((Object)TypeKind.DECLARED) || !method.getModifiers().contains((Object)Modifier.STATIC) || method.getParameters().size() != 1) {
            return false;
        }
        List<? extends TypeParameterElement> typeParameters = method.getTypeParameters();
        List<? extends TypeMirror> targetTypeArguments = MoreTypes.asDeclared(targetType).getTypeArguments();
        if (typeParameters.size() != targetTypeArguments.size()) {
            return false;
        }
        LinkedHashMap<Equivalence.Wrapper<TypeVariable>, TypeMirror> typeVariables = new LinkedHashMap<Equivalence.Wrapper<TypeVariable>, TypeMirror>();
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeVariable v2 = MoreTypes.asTypeVariable(typeParameters.get(i).asType());
            typeVariables.put(MoreTypes.equivalence().wrap(v2), targetTypeArguments.get(i));
        }
        Function<TypeVariable, TypeMirror> substitute = v -> (TypeMirror)typeVariables.get(MoreTypes.equivalence().wrap(v));
        SubstitutionVisitor substitutionVisitor = new SubstitutionVisitor(substitute, typeUtils);
        TypeMirror formalParameterType = method.getParameters().get(0).asType();
        TypeMirror substitutedParameterType = (TypeMirror)substitutionVisitor.visit(formalParameterType, null);
        if (substitutedParameterType.getKind().equals((Object)TypeKind.WILDCARD) && (wildcard = MoreTypes.asWildcard(substitutedParameterType)).getExtendsBound() != null) {
            substitutedParameterType = wildcard.getExtendsBound();
        }
        return typeUtils.isAssignable(actualParameterType, substitutedParameterType);
    }

    static TypeMirror substituteTypeVariables(TypeMirror input, Function<TypeVariable, TypeMirror> substitute, Types typeUtils) {
        SubstitutionVisitor substitutionVisitor = new SubstitutionVisitor(substitute, typeUtils);
        return (TypeMirror)substitutionVisitor.visit(input, null);
    }

    private static class SubstitutionVisitor
    extends SimpleTypeVisitor8<TypeMirror, Void> {
        private final Function<TypeVariable, TypeMirror> substitute;
        private final Types typeUtils;

        SubstitutionVisitor(Function<TypeVariable, TypeMirror> substitute, Types typeUtils) {
            this.substitute = substitute;
            this.typeUtils = typeUtils;
        }

        @Override
        protected TypeMirror defaultAction(TypeMirror t2, Void p) {
            return t2;
        }

        @Override
        public TypeMirror visitTypeVariable(TypeVariable t2, Void p) {
            TypeMirror substituted = this.substitute.apply(t2);
            return substituted == null ? t2 : substituted;
        }

        @Override
        public TypeMirror visitDeclared(DeclaredType t2, Void p) {
            List<? extends TypeMirror> typeArguments = t2.getTypeArguments();
            TypeMirror[] substitutedTypeArguments = new TypeMirror[typeArguments.size()];
            for (int i = 0; i < typeArguments.size(); ++i) {
                substitutedTypeArguments[i] = (TypeMirror)this.visit(typeArguments.get(i));
            }
            return this.typeUtils.getDeclaredType(MoreElements.asType(t2.asElement()), substitutedTypeArguments);
        }

        @Override
        public TypeMirror visitWildcard(WildcardType t2, Void p) {
            TypeMirror ext = this.visitOrNull(t2.getExtendsBound());
            if (ext != null && ext.getKind().equals((Object)TypeKind.WILDCARD)) {
                return ext;
            }
            return this.typeUtils.getWildcardType(ext, this.visitOrNull(t2.getSuperBound()));
        }

        @Override
        public TypeMirror visitArray(ArrayType t2, Void p) {
            TypeMirror comp = (TypeMirror)this.visit(t2.getComponentType());
            if (comp.getKind().equals((Object)TypeKind.WILDCARD)) {
                comp = MoreTypes.asWildcard(comp).getExtendsBound();
            }
            return this.typeUtils.getArrayType(comp);
        }

        private TypeMirror visitOrNull(TypeMirror t2) {
            if (t2 == null) {
                return null;
            }
            return (TypeMirror)this.visit(t2);
        }
    }
}

