/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.testtype.SubPlan;
import com.android.compatibility.common.tradefed.testtype.suite.CompatibilitySuiteModuleLoader;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.testtype.suite.SuiteModuleLoader;
import com.android.tradefed.testtype.suite.SuiteTestFilter;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="compatibility")
public final class CompatibilityTestSuite
extends BaseTestSuite {
    public static final String SUBPLAN_OPTION = "subplan";
    @Option(name="retry", shortName=114, description="Copy of --retry from CompatibilityTest to prevent using it.")
    private Integer mRetrySessionId = null;
    @Option(name="subplan", description="the subplan to run", importance=Option.Importance.IF_UNSET)
    private String mSubPlan;
    private CompatibilityBuildHelper mBuildHelper;

    public CompatibilityTestSuite() {
        this.setSkipjarLoading(true);
    }

    public void setBuild(IBuildInfo buildInfo) {
        super.setBuild(buildInfo);
        this.mBuildHelper = new CompatibilityBuildHelper(buildInfo);
    }

    public File getTestsDir() throws FileNotFoundException {
        return this.mBuildHelper.getTestsDir();
    }

    public SuiteModuleLoader createModuleLoader(Map<String, LinkedHashSet<SuiteTestFilter>> includeFiltersFormatted, Map<String, LinkedHashSet<SuiteTestFilter>> excludeFiltersFormatted, List<String> testArgs, List<String> moduleArgs) {
        return new CompatibilitySuiteModuleLoader(includeFiltersFormatted, excludeFiltersFormatted, testArgs, moduleArgs);
    }

    public LinkedHashMap<String, IConfiguration> loadTests() {
        if (this.mRetrySessionId != null) {
            throw new IllegalArgumentException(String.format("--retry cannot be specified with %s[*].xml. Use 'run retry --retry <session id>' instead.", TestSuiteInfo.getInstance().getName().toLowerCase()));
        }
        return super.loadTests();
    }

    protected final void setupFilters(File testDir) throws FileNotFoundException {
        if (this.mSubPlan != null) {
            try {
                File subPlanFile = new File(this.mBuildHelper.getSubPlansDir(), this.mSubPlan + ".xml");
                if (!subPlanFile.exists()) {
                    throw new IllegalArgumentException(String.format("Could not retrieve subplan \"%s\"", this.mSubPlan));
                }
                FileInputStream subPlanInputStream = new FileInputStream(subPlanFile);
                SubPlan subPlan = new SubPlan();
                subPlan.parse(subPlanInputStream);
                this.setIncludeFilter(subPlan.getIncludeFilters());
                this.setExcludeFilter(subPlan.getExcludeFilters());
                this.setInLocalRetry(true);
            }
            catch (AbstractXmlParser.ParseException e) {
                throw new RuntimeException(String.format("Unable to find or parse subplan %s", this.mSubPlan), e);
            }
        }
        super.setupFilters(testDir);
    }

    public final void resetRetryId() {
        this.mRetrySessionId = null;
    }

    public LinkedHashMap<String, IConfiguration> loadingStrategy(Set<IAbi> abis, List<File> testsDirs, String suitePrefix, String suiteTag) {
        LinkedHashMap loadedConfigs = super.loadingStrategy(abis, testsDirs, suitePrefix, suiteTag);
        if (loadedConfigs.size() == 0) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.DEBUG, (String)"No module that needed to run were found. nothing to do.");
        }
        return loadedConfigs;
    }
}

