/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

@OptionClass(alias="interactive-result-collector")
public class InteractiveResultCollector
extends BaseTargetPreparer
implements IInvocationContextReceiver {
    @Option(name="host-path", description="The host-side relative path to the directory where results should be collected. If not specified, defaults to the 'screenshots' directory.")
    private String hostPath = "screenshots";
    @Option(name="create-module-dir", description="Whether creating a sub-directory under the host-path to distinguish files of different modules.")
    private boolean createModuleDir = true;
    @Option(name="device-cleanup", description="Whether all files in the device folders should be cleaned up during setup. Note that the preparer does not verify that files/directories have been deleted successfully.")
    private boolean deviceCleanup = true;
    @Option(name="device-paths", description="The list of paths to the files stored on the device.")
    private List<String> devicePaths = new ArrayList<String>();
    private String mModuleName = null;
    private String mModuleAbi = null;

    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        ITestDevice mDevice = testInfo.getDevice();
        if (!(testInfo.getBuildInfo() instanceof IDeviceBuildInfo)) {
            throw new TargetSetupError("Invalid buildInfo, expecting an IDeviceBuildInfo", mDevice.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.UNDETERMINED);
        }
        if (this.deviceCleanup && !this.devicePaths.isEmpty()) {
            for (String devicePath : this.devicePaths) {
                if (devicePath.isEmpty()) continue;
                LogUtil.CLog.d((String)"Start clean up path: %s", (Object[])new Object[]{devicePath});
                mDevice.deleteFile(devicePath);
            }
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (e != null && e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.e((String)"Module finished with DeviceNotAvailable, skip collecting results.");
            return;
        }
        File hostResultDir = null;
        if (!this.devicePaths.isEmpty()) {
            try {
                hostResultDir = this.getHostResultDir(testInfo);
                if (!hostResultDir.exists()) {
                    hostResultDir.mkdirs();
                }
            }
            catch (FileNotFoundException exception) {
                LogUtil.CLog.e((Throwable)exception);
                return;
            }
        }
        if (hostResultDir == null) {
            return;
        }
        ITestDevice testDevice = testInfo.getDevice();
        for (String devicePath : this.devicePaths) {
            if (devicePath.isEmpty() || !testDevice.pullDir(devicePath, hostResultDir)) continue;
            LogUtil.CLog.d((String)String.format("Successfully pulled %s to %s.", devicePath, hostResultDir.getAbsolutePath()));
        }
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        if (this.createModuleDir) {
            List moduleAbis;
            List moduleNames = invocationContext.getAttributes().get((Object)"module-name");
            if (moduleNames != null && !moduleNames.isEmpty()) {
                this.mModuleName = (String)moduleNames.get(0);
            }
            if ((moduleAbis = invocationContext.getAttributes().get((Object)"module-abi")) != null && !moduleAbis.isEmpty()) {
                this.mModuleAbi = (String)moduleAbis.get(0);
            }
        } else {
            LogUtil.CLog.d((String)"Skip initializing the module name and abi as create-module-dir is false.");
        }
    }

    private File getHostResultDir(TestInformation testInfo) throws FileNotFoundException {
        File resultDir = new CompatibilityBuildHelper(testInfo.getBuildInfo()).getResultDir();
        return this.mModuleName == null ? Paths.get(resultDir.getAbsolutePath(), this.hostPath).toFile() : this.getHostResultDir(resultDir.getAbsolutePath());
    }

    private File getHostResultDir(String resultDir) {
        String subDirName = this.mModuleAbi == null ? this.mModuleName : String.format("%s__%s", this.mModuleName, this.mModuleAbi);
        return Paths.get(resultDir, this.hostPath, subDirName).toFile();
    }
}

