/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.util.HostInfoStore;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@OptionClass(alias="incremental-deqp-preparer")
public class IncrementalDeqpPreparer
extends BaseTargetPreparer {
    @Option(name="run-mode", description="The run mode for incremental dEQP.")
    private RunMode mRunMode = RunMode.LIGHTWEIGHT_RUN;
    @Option(name="fallback-strategy", description="The fallback strategy to apply if the incremental dEQP qualification testing for the builds fails.")
    private FallbackStrategy mFallbackStrategy = FallbackStrategy.ABORT_IF_ANY_EXCEPTION;
    private static final long STRIP_TIMEOUT = 20000L;
    private static final String MODULE_NAME = "CtsDeqpTestCases";
    private static final String DEVICE_DEQP_DIR = "/data/local/tmp";
    private static final List<String> BASELINE_DEQP_TEST_LIST = Arrays.asList("gles2-incremental-deqp-baseline", "gles3-incremental-deqp-baseline", "gles31-incremental-deqp-baseline", "vk-incremental-deqp-baseline");
    private static final List<String> REPRESENTATIVE_DEQP_TEST_LIST = Arrays.asList("vk-incremental-deqp", "gles3-incremental-deqp");
    private static final List<String> DEQP_BINARY_LIST = Arrays.asList("deqp-binary32", "deqp-binary64");
    private static final String DEQP_CASE_LIST_FILE_EXTENSION = ".txt";
    private static final String PERF_FILE_EXTENSION = ".data";
    private static final String LOG_FILE_EXTENSION = ".qpa";
    private static final String RUN_MODE_ATTRIBUTE = "run_mode";
    private static final String MODULE_ATTRIBUTE = "module";
    private static final String MODULE_NAME_ATTRIBUTE = "module_name";
    private static final String DEPENDENCY_DETAILS_ATTRIBUTE = "deps_details";
    private static final String DEPENDENCY_NAME_ATTRIBUTE = "dep_name";
    private static final String DEPENDENCY_FILE_HASH_ATTRIBUTE = "file_hash";
    private static final String LLVM_STRIP_FILE_NAME = "llvm-strip";
    private static final Pattern EXCLUDE_DEQP_PATTERN = Pattern.compile("(^/data/|^/apex/|^\\[vdso\\]|^/dmabuf|^/kgsl-3d0|^/mali csf)");
    public static final String INCREMENTAL_DEQP_ATTRIBUTE_NAME = "incremental-deqp";
    public static final String INCREMENTAL_DEQP_REPORT_NAME = "IncrementalCtsDeviceInfo.deviceinfo.json";

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        block2: {
            try {
                ITestDevice device = testInfo.getDevice();
                CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(testInfo.getBuildInfo());
                IInvocationContext context = testInfo.getContext();
                this.runIncrementalDeqp(context, device, buildHelper, this.mRunMode);
            }
            catch (Exception e) {
                if (this.mFallbackStrategy != FallbackStrategy.ABORT_IF_ANY_EXCEPTION) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runIncrementalDeqp(IInvocationContext context, ITestDevice device, CompatibilityBuildHelper buildHelper, RunMode runMode) throws TargetSetupError, DeviceNotAvailableException {
        Class<IncrementalDeqpPreparer> clazz = IncrementalDeqpPreparer.class;
        synchronized (IncrementalDeqpPreparer.class) {
            File jsonFile;
            try {
                File deviceInfoDir = new File(buildHelper.getResultDir(), "device-info-files");
                jsonFile = new File(deviceInfoDir, INCREMENTAL_DEQP_REPORT_NAME);
                if (jsonFile.exists()) {
                    LogUtil.CLog.i((String)"Another shard has already checked dEQP dependencies.");
                    IncrementalDeqpPreparer.addBuildAttribute(context, INCREMENTAL_DEQP_ATTRIBUTE_NAME);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
            }
            catch (FileNotFoundException e) {
                throw new TargetSetupError("Fail to read invocation result directory.", device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            List<String> deqpTestList = RunMode.FULL_RUN.equals((Object)this.mRunMode) ? BASELINE_DEQP_TEST_LIST : REPRESENTATIVE_DEQP_TEST_LIST;
            Set<String> dependencies = this.getDeqpDependencies(device, deqpTestList);
            if (dependencies.isEmpty()) {
                throw new TargetSetupError("Fail to detect dEQP dependencies from the device.", (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            try (HostInfoStore store = new HostInfoStore(jsonFile);){
                store.open();
                store.addResult(RUN_MODE_ATTRIBUTE, runMode.name());
                store.startArray(MODULE_ATTRIBUTE);
                store.startGroup();
                store.addResult(MODULE_NAME_ATTRIBUTE, MODULE_NAME);
                store.startArray(DEPENDENCY_DETAILS_ATTRIBUTE);
                Map<String, String> currentBuildHashMap = this.getFileHash(dependencies, device, buildHelper);
                ArrayList<String> sortedDependencies = new ArrayList<String>(dependencies);
                Collections.sort(sortedDependencies);
                for (String dependency : sortedDependencies) {
                    store.startGroup();
                    store.addResult(DEPENDENCY_NAME_ATTRIBUTE, dependency);
                    store.addResult(DEPENDENCY_FILE_HASH_ATTRIBUTE, currentBuildHashMap.get(dependency));
                    store.endGroup();
                }
                store.endArray();
                store.endGroup();
                store.endArray();
                IncrementalDeqpPreparer.addBuildAttribute(context, INCREMENTAL_DEQP_ATTRIBUTE_NAME);
            }
            catch (IOException e) {
                throw new TargetSetupError("Failed to collect dependencies", (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            catch (Exception e) {
                throw new TargetSetupError("Failed to write incremental dEQP report", (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            finally {
                if (jsonFile.exists() && jsonFile.length() == 0L) {
                    FileUtil.deleteFile((File)jsonFile);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDeqpDependencies(ITestDevice device, List<String> testList) throws TargetSetupError, DeviceNotAvailableException {
        HashSet<String> result = new HashSet<String>();
        for (String test : testList) {
            for (String binaryName : DEQP_BINARY_LIST) {
                String fileNamePrefix = test + "-" + binaryName;
                String perfFile = "/data/local/tmp/" + fileNamePrefix + PERF_FILE_EXTENSION;
                String binaryFile = "/data/local/tmp/" + binaryName;
                String testFile = "/data/local/tmp/" + test + DEQP_CASE_LIST_FILE_EXTENSION;
                String logFile = "/data/local/tmp/" + fileNamePrefix + LOG_FILE_EXTENSION;
                String command = String.format("cd %s && simpleperf record -e cpu-cycles:u -o %s %s --deqp-caselist-file=%s --deqp-log-images=disable --deqp-log-shader-sources=disable --deqp-log-filename=%s --deqp-surface-type=fbo --deqp-surface-width=2048 --deqp-surface-height=2048", DEVICE_DEQP_DIR, perfFile, binaryFile, testFile, logFile);
                device.executeShellCommand(command);
                String dumpFile = "/data/local/tmp/" + fileNamePrefix + "-perf-dump.txt";
                String dumpCommand = String.format("simpleperf dump %s > %s", perfFile, dumpFile);
                device.executeShellCommand(dumpCommand);
                File localDumpFile = device.pullFile(dumpFile);
                try {
                    result.addAll(this.parseDump(localDumpFile));
                }
                finally {
                    if (localDumpFile == null) continue;
                    localDumpFile.delete();
                }
            }
        }
        return result;
    }

    protected Map<String, String> getFileHash(Set<String> fileNames, ITestDevice device, CompatibilityBuildHelper buildHelper) throws DeviceNotAvailableException, TargetSetupError, FileNotFoundException {
        File llvm_strip_file = new File(buildHelper.getTestsDir(), LLVM_STRIP_FILE_NAME);
        if (!(llvm_strip_file.exists() || (llvm_strip_file = FileUtil.findFile((File)buildHelper.getTestsDir(), (String)LLVM_STRIP_FILE_NAME)) != null && llvm_strip_file.isFile())) {
            throw new FileNotFoundException("Cannot find llvm strip binary: llvm-strip");
        }
        IRunUtil runUtil = this.createRunUtil();
        HashMap<String, String> fileHashes = new HashMap<String, String>();
        for (String file : fileNames) {
            File pulledFile = device.pullFile(file);
            if (pulledFile == null) {
                throw new TargetSetupError(String.format("Fail to load file: %s from the device.", file), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            String stripped_file_path = String.format("%s%sstripped_%s", pulledFile.getParent(), File.separator, pulledFile.getName());
            CommandResult result = runUtil.runTimedCmd(20000L, new String[]{llvm_strip_file.getAbsolutePath(), "--strip-all", "--keep-section=.ARM.attributes", "--remove-section=.note.gnu.build-id", pulledFile.getAbsolutePath(), "-o", stripped_file_path});
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.w((String)"Fail to strip build id for file: %s. The original file will be used.", (Object[])new Object[]{file});
                String md5 = FileUtil.calculateMd5((File)pulledFile);
                fileHashes.put(file, md5);
            } else {
                File stripped_file = new File(stripped_file_path);
                if (stripped_file.exists()) {
                    String md5 = FileUtil.calculateMd5((File)stripped_file);
                    fileHashes.put(file, md5);
                    FileUtil.deleteFile((File)stripped_file);
                } else {
                    throw new TargetSetupError(String.format("Fail to find the stripped file: %s.", stripped_file_path), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
                }
            }
            FileUtil.deleteFile((File)pulledFile);
        }
        return fileHashes;
    }

    IRunUtil createRunUtil() {
        return new RunUtil();
    }

    protected Set<String> parseDump(File localDumpFile) throws TargetSetupError {
        boolean binaryExecuted = false;
        boolean correctMmap = false;
        HashSet<String> result = new HashSet<String>();
        if (localDumpFile == null) {
            return result;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(localDumpFile));
            while ((line = br.readLine()) != null) {
                String dependency;
                if (!binaryExecuted) {
                    Pattern pattern = Pattern.compile(" comm .*deqp-binary");
                    if (!pattern.matcher(line).find()) continue;
                    binaryExecuted = true;
                    continue;
                }
                if (!line.startsWith(" ")) {
                    boolean bl = correctMmap = line.startsWith("record mmap") && !line.contains("misc 1");
                }
                if (!line.contains("filename") || !correctMmap || EXCLUDE_DEQP_PATTERN.matcher(dependency = line.substring(line.indexOf("filename") + 9).trim()).find()) continue;
                result.add(dependency);
            }
        }
        catch (IOException e) {
            try {
                throw new TargetSetupError(String.format("Could not parse file: %s", localDumpFile.getAbsoluteFile()), (Throwable)e, (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            catch (Throwable throwable) {
                StreamUtil.close(br);
                throw throwable;
            }
        }
        StreamUtil.close((Closeable)br);
        return result;
    }

    private static void addBuildAttribute(IInvocationContext context, String buildAttributeName) {
        for (IBuildInfo bi : context.getBuildInfos()) {
            bi.addBuildAttribute(buildAttributeName, "");
        }
    }

    public static enum RunMode {
        FULL_RUN,
        LIGHTWEIGHT_RUN;

    }

    private static enum FallbackStrategy {
        RUN_FULL_DEQP,
        ABORT_IF_ANY_EXCEPTION;

    }
}

