/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.suite.CertificationChecksumHelper;
import com.android.compatibility.common.tradefed.result.suite.CertificationReportCreator;
import com.android.compatibility.common.tradefed.result.suite.CertificationResultXml;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.ShardListener;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.result.suite.IFormatterGenerator;
import com.android.tradefed.result.suite.XmlFormattedGeneratorReporter;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@OptionClass(alias="result-reporter")
public class CertificationSuiteResultReporter
extends XmlFormattedGeneratorReporter
implements ITestSummaryListener {
    public static final String LATEST_LINK_NAME = "latest";
    public static final String SUMMARY_FILE = "invocation_summary.txt";
    public static final String BUILD_FINGERPRINT = "cts:build_fingerprint";
    @Option(name="result-server", description="Server to publish test results.")
    @Deprecated
    private String mResultServer;
    @Option(name="disable-result-posting", description="Disable result posting into report server.")
    @Deprecated
    private boolean mDisableResultPosting = false;
    @Option(name="include-test-log-tags", description="Include test log tags in report.")
    private boolean mIncludeTestLogTags = false;
    @Option(name="use-log-saver", description="Also saves generated result with log saver")
    private boolean mUseLogSaver = false;
    @Option(name="compress-logs", description="Whether logs will be saved with compression")
    private boolean mCompressLogs = true;
    public static final String INCLUDE_HTML_IN_ZIP = "html-in-zip";
    @Option(name="html-in-zip", description="Whether failure summary report is included in the zip fie.")
    @Deprecated
    private boolean mIncludeHtml = false;
    @Option(name="result-attribute", description="Extra key-value pairs to be added as attributes and corresponding values of the \"Result\" tag in the result XML.")
    private Map<String, String> mResultAttributes = new HashMap<String, String>();
    @Option(name="cts-on-gsi-variant", description="Workaround for the R release to ensure the CTS-on-GSI report can be parsed by the APFE.")
    private boolean mCtsOnGsiVariant = false;
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir = null;
    private File mLogDir = null;
    private LogFileSaver mTestLogSaver;
    private File mLogDirWithModule = null;
    private LogFileSaver mBaseTestLogSaver;
    private Map<LogFile, InputStreamSource> mPreInvocationLogs = new HashMap<LogFile, InputStreamSource>();
    private ILogSaver mLogSaver;
    private String mReferenceUrl;
    private Map<String, String> mLoggedFiles = new LinkedHashMap<String, String>();
    private static final String[] RESULT_RESOURCES = new String[]{"compatibility_result.css", "compatibility_result.xsl", "logo.png"};

    public final void invocationStarted(IInvocationContext context) {
        super.invocationStarted(context);
        if (this.mBuildHelper == null) {
            this.mBuildHelper = this.createBuildHelper();
        }
        if (this.mResultDir == null) {
            this.initializeResultDirectories();
        }
    }

    CompatibilityBuildHelper createBuildHelper() {
        return new CompatibilityBuildHelper(this.getPrimaryBuildInfo());
    }

    public void testLog(String name, LogDataType type, InputStreamSource stream) {
        if (name.endsWith(".deviceinfo.json")) {
            this.testLogDeviceInfo(name, stream);
            return;
        }
        if (this.mTestLogSaver == null) {
            LogFile info = new LogFile(name, null, type);
            this.mPreInvocationLogs.put(info, (InputStreamSource)new SnapshotInputStreamSource(name, stream.createInputStream()));
            return;
        }
        try {
            File logFile = null;
            if (this.mCompressLogs) {
                try (InputStream inputStream = stream.createInputStream();){
                    logFile = this.mTestLogSaver.saveAndGZipLogData(name, type, inputStream);
                }
            }
            try (InputStream inputStream = stream.createInputStream();){
                logFile = this.mTestLogSaver.saveLogData(name, type, inputStream);
            }
            LogUtil.CLog.d((String)"Saved logs for %s in %s", (Object[])new Object[]{name, logFile.getAbsolutePath()});
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to write log for %s", (Object[])new Object[]{name});
            LogUtil.CLog.e((Throwable)e);
        }
    }

    private void testLogDeviceInfo(String name, InputStreamSource stream) {
        try {
            File ediDir = new File(this.mResultDir, "device-info-files");
            ediDir.mkdirs();
            File ediFile = new File(ediDir, name);
            if (!ediFile.exists()) {
                FileUtil.writeToFile((InputStream)stream.createInputStream(), (File)ediFile);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w((String)"Failed to write device info %s to result", (Object[])new Object[]{name});
            LogUtil.CLog.e((Throwable)e);
        }
    }

    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        if (this.mIncludeTestLogTags) {
            switch (dataType) {
                case BUGREPORT: 
                case LOGCAT: 
                case PNG: {
                    this.mLoggedFiles.put(dataName, logFile.getUrl());
                    break;
                }
            }
        }
    }

    public void putSummary(List<TestSummary> summaries) {
        for (TestSummary summary : summaries) {
            if (this.mReferenceUrl != null || summary.getSummary().getString() == null) continue;
            this.mReferenceUrl = summary.getSummary().getString();
        }
    }

    public void setLogSaver(ILogSaver saver) {
        this.mLogSaver = saver;
    }

    private void initializeResultDirectories() {
        LogUtil.CLog.d((String)"Initializing result directory");
        try {
            this.mResultDir = this.mBuildHelper.getResultDir();
            if (this.mResultDir != null) {
                this.mResultDir.mkdirs();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (this.mResultDir == null) {
            throw new RuntimeException("Result Directory was not created");
        }
        if (!this.mResultDir.exists()) {
            throw new RuntimeException("Result Directory was not created: " + this.mResultDir.getAbsolutePath());
        }
        LogUtil.CLog.d((String)"Results Directory: %s", (Object[])new Object[]{this.mResultDir.getAbsolutePath()});
        try {
            this.mLogDir = this.mBuildHelper.getInvocationLogDir();
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        if (this.mLogDir != null && this.mLogDir.mkdirs()) {
            LogUtil.CLog.d((String)"Created log dir %s", (Object[])new Object[]{this.mLogDir.getAbsolutePath()});
        }
        if (this.mLogDir == null || !this.mLogDir.exists()) {
            throw new IllegalArgumentException(String.format("Could not create log dir %s", this.mLogDir.getAbsolutePath()));
        }
        if (this.mTestLogSaver == null) {
            this.mBaseTestLogSaver = this.mTestLogSaver = new LogFileSaver(this.mLogDir);
            for (LogFile earlyLog : this.mPreInvocationLogs.keySet()) {
                InputStreamSource source = this.mPreInvocationLogs.get(earlyLog);
                try {
                    this.testLog(earlyLog.getPath(), earlyLog.getType(), source);
                }
                finally {
                    if (source == null) continue;
                    source.close();
                }
            }
            this.mPreInvocationLogs.clear();
        }
    }

    public IFormatterGenerator createFormatter() {
        return new CertificationResultXml(this.mBuildHelper.getSuiteName(), this.mBuildHelper.getSuiteVersion(), this.createSuiteVariant(), this.mBuildHelper.getSuitePlan(), this.mBuildHelper.getSuiteBuild(), this.mReferenceUrl, this.getLogUrl(), this.mResultAttributes);
    }

    public void preFormattingSetup(IFormatterGenerator formater) {
        super.preFormattingSetup(formater);
        TestSummary summary = this.getSummary();
        try {
            File summaryFile = new File(this.mResultDir, SUMMARY_FILE);
            FileUtil.writeToFile((String)summary.getSummary().toString(), (File)summaryFile);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to save the summary.");
            LogUtil.CLog.e((Throwable)e);
        }
        this.copyDynamicConfigFiles();
        this.copyFormattingFiles(this.mResultDir, this.mBuildHelper.getSuiteName());
    }

    public File createResultDir() throws IOException {
        return this.mResultDir;
    }

    public void postFormattingStep(File resultDir, File reportFile) {
        super.postFormattingStep(resultDir, reportFile);
        this.createChecksum(resultDir, this.getMergedTestRunResults(), (String)this.getPrimaryBuildInfo().getBuildAttributes().get(BUILD_FINGERPRINT));
        Path latestLink = this.createLatestLinkDirectory(this.mResultDir.toPath());
        if (latestLink != null) {
            LogUtil.CLog.i((String)("Latest results link: " + latestLink.toAbsolutePath()));
        }
        if ((latestLink = this.createLatestLinkDirectory(this.mLogDir.toPath())) != null) {
            LogUtil.CLog.i((String)("Latest logs link: " + latestLink.toAbsolutePath()));
        }
        for (ITestInvocationListener resultReporter : this.getConfiguration().getTestInvocationListeners()) {
            if (resultReporter instanceof CertificationReportCreator) {
                ((CertificationReportCreator)resultReporter).setReportFile(reportFile);
            }
            if (!(resultReporter instanceof ShardListener)) continue;
            for (ITestInvocationListener subListener : ((ShardListener)resultReporter).getUnderlyingResultReporter()) {
                if (!(subListener instanceof CertificationReportCreator)) continue;
                ((CertificationReportCreator)subListener).setReportFile(reportFile);
            }
        }
    }

    private String getLogUrl() {
        if (!this.mUseLogSaver || this.mLogSaver == null) {
            return null;
        }
        return this.mLogSaver.getLogReportDir().getUrl();
    }

    private Path createLatestLinkDirectory(Path directory) {
        Path link = null;
        Path parent = directory.getParent();
        if (parent != null) {
            link = parent.resolve(LATEST_LINK_NAME);
            try {
                Files.deleteIfExists(link);
                Files.createSymbolicLink(link, directory, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)"Exception while attempting to create 'latest' link to: [%s]", (Object[])new Object[]{directory});
                LogUtil.CLog.e((Throwable)ioe);
                return null;
            }
            catch (UnsupportedOperationException uoe) {
                LogUtil.CLog.e((String)"Failed to create 'latest' symbolic link - unsupported operation");
                return null;
            }
        }
        return link;
    }

    private void copyDynamicConfigFiles() {
        File configDir = new File(this.mResultDir, "config");
        if (!configDir.exists() && !configDir.mkdir()) {
            LogUtil.CLog.w((String)"Failed to make dynamic config directory \"%s\" in the result.", (Object[])new Object[]{configDir.getAbsolutePath()});
        }
        HashSet<String> uniqueModules = new HashSet<String>();
        for (IBuildInfo buildInfo : this.getInvocationContext().getBuildInfos()) {
            CompatibilityBuildHelper helper = new CompatibilityBuildHelper(buildInfo);
            Map<String, File> dcFiles = helper.getDynamicConfigFiles();
            for (String moduleName : dcFiles.keySet()) {
                File srcFile = dcFiles.get(moduleName);
                if (!uniqueModules.contains(moduleName)) {
                    File destFile = new File(configDir, moduleName + ".dynamic");
                    if (destFile.exists()) continue;
                    try {
                        FileUtil.copyFile((File)srcFile, (File)destFile);
                        uniqueModules.add(moduleName);
                    }
                    catch (IOException e) {
                        LogUtil.CLog.w((String)"Failure when copying config file \"%s\" to \"%s\" for module %s", (Object[])new Object[]{srcFile.getAbsolutePath(), destFile.getAbsolutePath(), moduleName});
                        LogUtil.CLog.e((Throwable)e);
                    }
                }
                FileUtil.deleteFile((File)srcFile);
            }
        }
    }

    private void copyFormattingFiles(File resultsDir, String suiteName) {
        for (String resultFileName : RESULT_RESOURCES) {
            InputStream configStream = CertificationResultXml.class.getResourceAsStream(String.format("/report/%s-%s", suiteName, resultFileName));
            if (configStream == null) {
                configStream = CertificationResultXml.class.getResourceAsStream(String.format("/report/%s", resultFileName));
            }
            if (configStream != null) {
                File resultFile = new File(resultsDir, resultFileName);
                try {
                    FileUtil.writeToFile((InputStream)configStream, (File)resultFile);
                }
                catch (IOException e) {
                    LogUtil.CLog.w((String)"Failed to write %s to file", (Object[])new Object[]{resultFileName});
                }
                continue;
            }
            LogUtil.CLog.w((String)"Failed to load %s from jar", (Object[])new Object[]{resultFileName});
        }
    }

    private void createChecksum(File resultDir, Collection<TestRunResult> results, String buildFingerprint) {
        CertificationChecksumHelper.tryCreateChecksum(resultDir, results, buildFingerprint);
    }

    private String createSuiteVariant() {
        IConfiguration currentConfig = this.getConfiguration();
        String commandLine = currentConfig.getCommandLine();
        for (SuiteVariant var : SuiteVariant.values()) {
            if (!commandLine.startsWith(var.getConfigName() + " ") && !commandLine.equals(var.getConfigName())) continue;
            return var.getReportDisplayName();
        }
        return null;
    }

    public void testModuleStarted(IInvocationContext moduleContext) {
        super.testModuleStarted(moduleContext);
        String moduleName = moduleContext.getConfigurationDescriptor().getModuleName();
        if (moduleName == null) {
            return;
        }
        try {
            this.mLogDirWithModule = CertificationSuiteResultReporter.createLogDirWithModule(this.mTestLogSaver.getFileDir(), moduleName);
            this.mTestLogSaver = new LogFileSaver(this.mLogDirWithModule);
        }
        catch (IOException e) {
            LogUtil.CLog.w((String)String.format("Failed to create log dir with module %s.", moduleName));
            return;
        }
    }

    public void testModuleEnded() {
        super.testModuleEnded();
        if (this.mLogDirWithModule == null) {
            return;
        }
        if (!CertificationSuiteResultReporter.containsFiles(this.mLogDirWithModule)) {
            FileUtil.recursiveDelete((File)this.mLogDirWithModule);
        }
        this.mLogDirWithModule = null;
        this.mTestLogSaver = this.mBaseTestLogSaver;
    }

    private static boolean containsFiles(File rootDir) {
        long fileCount = 0L;
        try (Stream<Path> stream = Files.walk(Paths.get(rootDir.getAbsolutePath(), new String[0]), FileVisitOption.FOLLOW_LINKS);){
            fileCount = stream.filter(p -> p.toFile().isFile()).count();
        }
        catch (IOException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        return fileCount > 0L;
    }

    private static File createLogDirWithModule(File logDir, String moduleName) throws IOException {
        ArrayList<String> pathSegments = new ArrayList<String>();
        pathSegments.add(moduleName);
        File dirWithModule = FileUtil.getFileForPath((File)logDir, (String[])pathSegments.toArray(new String[0]));
        if (dirWithModule.exists()) {
            if (dirWithModule.isDirectory()) {
                return dirWithModule;
            }
            String msg = String.format("Cannot create dir %s. File already exists.", dirWithModule.getAbsolutePath());
            LogUtil.CLog.w((String)msg);
            throw new IOException(msg);
        }
        if (FileUtil.mkdirsRWX((File)dirWithModule)) {
            return dirWithModule;
        }
        String msg = String.format("Cannot create output dir %s. Failed to create directory.", dirWithModule.getAbsolutePath());
        LogUtil.CLog.w((String)msg);
        throw new IOException(msg);
    }

    private static enum SuiteVariant {
        CTS_ON_GSI("CTS_ON_GSI", "cts-on-gsi");

        private final String mReportDisplayName;
        private final String mConfigName;

        private SuiteVariant(String reportName, String configName) {
            this.mReportDisplayName = reportName;
            this.mConfigName = configName;
        }

        public String getReportDisplayName() {
            return this.mReportDisplayName;
        }

        public String getConfigName() {
            return this.mConfigName;
        }
    }
}

