/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CollectorUtil {
    private static final String TEST_METRICS_PATTERN = "\\\"([a-z0-9_]*)\\\":(\\{[^{}]*\\})";

    private CollectorUtil() {
    }

    public static void pullFromHost(File src, File dest) {
        try {
            if (src.listFiles() != null) {
                for (File srcReportLog : src.listFiles()) {
                    File destReportLog = new File(dest, srcReportLog.getName());
                    CollectorUtil.merge(srcReportLog, destReportLog);
                }
            }
            FileUtil.recursiveDelete((File)src);
        }
        catch (IOException | JSONException e) {
            LogUtil.CLog.e((String)"Caught exception during pull.");
            LogUtil.CLog.e((Throwable)e);
        }
    }

    public static void reformatRepeatedStreams(File resultDir) {
        try {
            if (resultDir.listFiles() != null) {
                File[] reportLogs;
                for (File reportLog : reportLogs = resultDir.listFiles()) {
                    CollectorUtil.writeFile(reportLog, CollectorUtil.reformatJsonString(CollectorUtil.readFile(reportLog)));
                }
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Caught exception during reformatting.");
            LogUtil.CLog.e((Throwable)e);
        }
    }

    private static String readFile(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        return stringBuilder.toString();
    }

    private static void writeFile(File file, String jsonString) throws IOException {
        file.createNewFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(jsonString, 0, jsonString.length());
        }
    }

    public static String reformatJsonString(String jsonString) {
        StringBuilder newJsonBuilder = new StringBuilder();
        HashMap jsonMap = new HashMap();
        Pattern p = Pattern.compile(TEST_METRICS_PATTERN);
        Matcher m = p.matcher(jsonString);
        if (!m.find()) {
            return jsonString;
        }
        do {
            String key = m.group(1);
            String value = m.group(2);
            if (!jsonMap.containsKey(key)) {
                jsonMap.put(key, new ArrayList());
            }
            ((List)jsonMap.get(key)).add(value);
        } while (m.find());
        newJsonBuilder.append("{");
        boolean firstLine = true;
        for (String key : jsonMap.keySet()) {
            if (!firstLine) {
                newJsonBuilder.append(",");
            } else {
                firstLine = false;
            }
            newJsonBuilder.append("\"").append(key).append("\":[");
            boolean firstValue = true;
            for (String stream : (List)jsonMap.get(key)) {
                if (!firstValue) {
                    newJsonBuilder.append(",");
                } else {
                    firstValue = false;
                }
                newJsonBuilder.append(stream);
            }
            newJsonBuilder.append("]");
        }
        newJsonBuilder.append("}");
        return newJsonBuilder.toString();
    }

    public static void merge(File origFile, File destFile) throws JSONException, IOException {
        JSONObject mergedJson = new JSONObject(CollectorUtil.readFile(origFile));
        if (destFile.exists()) {
            JSONObject destFileJson = new JSONObject(CollectorUtil.readFile(destFile));
            Iterator streams = destFileJson.keys();
            while (streams.hasNext()) {
                String stream = (String)streams.next();
                JSONArray testResults = destFileJson.getJSONArray(stream);
                if (mergedJson.has(stream)) {
                    for (int i = 0; i < testResults.length(); ++i) {
                        JSONObject testResult = testResults.getJSONObject(i);
                        mergedJson.accumulate(stream, (Object)testResult);
                    }
                    continue;
                }
                mergedJson.put(stream, (Object)testResults);
            }
        }
        FileUtil.writeToFile((String)mergedJson.toString(), (File)destFile);
    }
}

