/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.testtype.ISubPlan;
import com.android.compatibility.common.util.TestFilter;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kxml2.io.KXmlSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SubPlan
extends AbstractXmlParser
implements ISubPlan {
    private final Set<String> mIncludes = new HashSet<String>();
    private final Set<String> mExcludes = new HashSet<String>();
    private static final String ENCODING = "UTF-8";
    private static final String NS = null;
    private static final String VERSION_ATTR = "version";
    private static final String SUBPLAN_VERSION = "2.0";
    private static final String SUBPLAN_TAG = "SubPlan";
    private static final String ENTRY_TAG = "Entry";
    private static final String EXCLUDE_ATTR = "exclude";
    private static final String INCLUDE_ATTR = "include";
    private static final String ABI_ATTR = "abi";
    private static final String NAME_ATTR = "name";

    public void addIncludeFilter(String filter) {
        this.mIncludes.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludes.addAll(filters);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludes.add(filter);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludes.addAll(filters);
    }

    public Set<String> getIncludeFilters() {
        return new HashSet<String>(this.mIncludes);
    }

    public Set<String> getExcludeFilters() {
        return new HashSet<String>(this.mExcludes);
    }

    public void clearExcludeFilters() {
        this.mExcludes.clear();
    }

    public void clearIncludeFilters() {
        this.mIncludes.clear();
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput(stream, ENCODING);
        serializer.startDocument(ENCODING, Boolean.valueOf(false));
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startTag(NS, SUBPLAN_TAG);
        serializer.attribute(NS, VERSION_ATTR, SUBPLAN_VERSION);
        ArrayList<String> sortedIncludes = new ArrayList<String>(this.mIncludes);
        ArrayList<String> sortedExcludes = new ArrayList<String>(this.mExcludes);
        Collections.sort(sortedIncludes);
        Collections.sort(sortedExcludes);
        for (String include : sortedIncludes) {
            serializer.startTag(NS, ENTRY_TAG);
            serializer.attribute(NS, INCLUDE_ATTR, include);
            serializer.endTag(NS, ENTRY_TAG);
        }
        for (String exclude : sortedExcludes) {
            serializer.startTag(NS, ENTRY_TAG);
            serializer.attribute(NS, EXCLUDE_ATTR, exclude);
            serializer.endTag(NS, ENTRY_TAG);
        }
        serializer.endTag(NS, SUBPLAN_TAG);
        serializer.endDocument();
    }

    protected DefaultHandler createXmlHandler() {
        return new EntryHandler();
    }

    private class EntryHandler
    extends DefaultHandler {
        private EntryHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (SubPlan.ENTRY_TAG.equals(localName)) {
                String includeString = attributes.getValue(SubPlan.INCLUDE_ATTR);
                String excludeString = attributes.getValue(SubPlan.EXCLUDE_ATTR);
                if (includeString != null && excludeString != null) {
                    throw new IllegalArgumentException("Cannot specify include and exclude filter in the same element");
                }
                String abiString = attributes.getValue(SubPlan.ABI_ATTR);
                String nameString = attributes.getValue(SubPlan.NAME_ATTR);
                if (excludeString == null) {
                    this.parseFilter(abiString, nameString, includeString, SubPlan.this.mIncludes);
                } else {
                    this.parseFilter(abiString, nameString, excludeString, SubPlan.this.mExcludes);
                }
            }
        }

        private void parseFilter(String abi, String name, String filter, Set<String> filterSet) {
            if (name == null) {
                filterSet.add(filter);
            } else {
                filterSet.add(new TestFilter(abi, name, filter).toString());
            }
        }
    }
}

