/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.build.CompatibilityBuildProvider;
import com.android.compatibility.common.tradefed.result.suite.CertificationResultXml;
import com.android.compatibility.common.tradefed.result.suite.PreviousSessionFileCopier;
import com.android.compatibility.common.tradefed.targetprep.BuildFingerPrintPreparer;
import com.android.compatibility.common.util.ResultHandler;
import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.proto.InvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.proto.ProtoResultParser;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.result.suite.SuiteResultHolder;
import com.android.tradefed.result.suite.XmlSuiteResultFormatter;
import com.android.tradefed.testtype.suite.retry.ITestSuiteResultLoader;
import com.android.tradefed.util.TestRecordInterpreter;
import com.android.tradefed.util.proto.TestRecordProtoUtil;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class PreviousResultLoader
implements ITestSuiteResultLoader {
    public static final String BUILD_FINGERPRINT = "build_fingerprint";
    public static final String BUILD_VENDOR_FINGERPRINT = "build_vendor_fingerprint";
    public static final String BUILD_FINGERPRINT_UNALTERED = "build_fingerprint_unaltered";
    public static final String RUN_HISTORY_KEY = "run_history";
    private static final String COMMAND_LINE_ARGS = "command_line_args";
    public static final String RETRY_OPTION = "retry";
    @Option(name="retry", shortName=114, description="retry a previous session's failed and not executed tests.", mandatory=true)
    private Integer mRetrySessionId = null;
    @Option(name="fingerprint-property", description="The property name to check for the fingerprint.")
    private String mFingerprintProperty = "ro.build.fingerprint";
    private TestRecordProto.TestRecord mTestRecord;
    private String mProtoPath = null;
    private IInvocationContext mPreviousContext;
    private String mExpectedFingerprint;
    private String mExpectedVendorFingerprint;
    private String mUnalteredFingerprint;
    private File mResultDir;
    private IBuildProvider mProvider;
    private Collection<XmlSuiteResultFormatter.RunHistory> mRunHistories;

    public void init() {
        IBuildInfo info = null;
        try {
            info = this.getProvider().getBuild();
        }
        catch (BuildRetrievalError e) {
            throw new RuntimeException(e);
        }
        CompatibilityBuildHelper helperBuild = new CompatibilityBuildHelper(info);
        this.mResultDir = null;
        try {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.DEBUG, (String)"Start loading the record protobuf.");
            this.mResultDir = ResultHandler.getResultDirectory((File)helperBuild.getResultsDir(), (Integer)this.mRetrySessionId);
            File protoDir = new File(this.mResultDir, "proto");
            if (new File(protoDir, "test-record.pb").exists()) {
                this.mTestRecord = TestRecordProtoUtil.readFromFile((File)new File(protoDir, "test-record.pb"));
            } else if (new File(protoDir, "test-record.pb0").exists()) {
                this.mTestRecord = TestRecordProtoUtil.readFromFile((File)new File(protoDir, "test-record.pb0"));
                this.mProtoPath = new File(protoDir, "test-record.pb").getAbsolutePath();
            } else {
                throw new RuntimeException("Could not find any test-record.pb to load.");
            }
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.DEBUG, (String)"Done loading the record protobuf.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        InvocationContext.Context contextProto = null;
        try {
            contextProto = (InvocationContext.Context)this.mTestRecord.getDescription().unpack(InvocationContext.Context.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        this.mPreviousContext = InvocationContext.fromProto((InvocationContext.Context)contextProto);
        this.mRunHistories = new ArrayList<XmlSuiteResultFormatter.RunHistory>();
        String runHistoryJSON = (String)this.mPreviousContext.getAttributes().getUniqueMap().get(RUN_HISTORY_KEY);
        if (runHistoryJSON != null) {
            Gson gson = new Gson();
            XmlSuiteResultFormatter.RunHistory[] runHistories = (XmlSuiteResultFormatter.RunHistory[])gson.fromJson(runHistoryJSON, XmlSuiteResultFormatter.RunHistory[].class);
            Collections.addAll(this.mRunHistories, runHistories);
        }
        try {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.DEBUG, (String)"Start parsing previous test_results.xml");
            CertificationResultXml xmlParser = new CertificationResultXml();
            SuiteResultHolder holder = xmlParser.parseResults(this.mResultDir, true);
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.DEBUG, (String)"Done parsing previous test_results.xml");
            this.mExpectedFingerprint = (String)holder.context.getAttributes().getUniqueMap().get(BUILD_FINGERPRINT);
            if (this.mExpectedFingerprint == null) {
                throw new IllegalArgumentException(String.format("Could not find the %s field in the loaded result.", BUILD_FINGERPRINT));
            }
            this.mExpectedVendorFingerprint = (String)holder.context.getAttributes().getUniqueMap().get(BUILD_VENDOR_FINGERPRINT);
            if (this.mExpectedVendorFingerprint == null) {
                throw new IllegalArgumentException(String.format("Could not find the %s field in the loaded result.", BUILD_VENDOR_FINGERPRINT));
            }
            this.mUnalteredFingerprint = (String)holder.context.getAttributes().getUniqueMap().get(BUILD_FINGERPRINT_UNALTERED);
            XmlSuiteResultFormatter.RunHistory newRun = new XmlSuiteResultFormatter.RunHistory();
            newRun.startTime = holder.startTime;
            newRun.endTime = holder.endTime;
            newRun.passedTests = holder.passedTests;
            newRun.failedTests = holder.failedTests;
            newRun.commandLineArgs = Strings.nullToEmpty((String)((String)holder.context.getAttributes().getUniqueMap().get(COMMAND_LINE_ARGS)));
            newRun.hostName = holder.hostName;
            this.mRunHistories.add(newRun);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCommandLine() {
        List command = this.mPreviousContext.getAttributes().get((Object)COMMAND_LINE_ARGS);
        if (command == null) {
            throw new RuntimeException("Couldn't find the command_line_args.");
        }
        return (String)command.get(0);
    }

    public CollectingTestListener loadPreviousResults() {
        if (this.mProtoPath != null) {
            int index = 0;
            CollectingTestListener results = new CollectingTestListener();
            ProtoResultParser parser = new ProtoResultParser((ITestInvocationListener)results, null, true);
            while (new File(this.mProtoPath + index).exists()) {
                try {
                    parser.processFileProto(new File(this.mProtoPath + index));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ++index;
            }
            return results;
        }
        return TestRecordInterpreter.interpreteRecord((TestRecordProto.TestRecord)this.mTestRecord);
    }

    public final void cleanUp() {
        if (this.mTestRecord != null) {
            this.mTestRecord = null;
        }
    }

    public final void customizeConfiguration(IConfiguration config) {
        List preparers = config.getTargetPreparers();
        ArrayList<BuildFingerPrintPreparer> newList = new ArrayList<BuildFingerPrintPreparer>();
        BuildFingerPrintPreparer fingerprintChecker = new BuildFingerPrintPreparer();
        fingerprintChecker.setExpectedFingerprint(this.mExpectedFingerprint);
        fingerprintChecker.setExpectedVendorFingerprint(this.mExpectedVendorFingerprint);
        fingerprintChecker.setFingerprintProperty(this.mFingerprintProperty);
        if (!Strings.isNullOrEmpty((String)this.mUnalteredFingerprint)) {
            fingerprintChecker.setUnalteredFingerprint(this.mUnalteredFingerprint);
        }
        newList.addAll(preparers);
        newList.add(fingerprintChecker);
        config.setTargetPreparers(newList);
        List listeners = config.getTestInvocationListeners();
        PreviousSessionFileCopier copier = new PreviousSessionFileCopier();
        copier.setPreviousSessionDir(this.mResultDir);
        listeners.add(copier);
        Gson gson = new Gson();
        config.getCommandOptions().getInvocationData().put((Object)RUN_HISTORY_KEY, (Object)gson.toJson(this.mRunHistories));
    }

    protected void setProvider(IBuildProvider provider) {
        this.mProvider = provider;
    }

    private IBuildProvider getProvider() {
        if (this.mProvider == null) {
            this.mProvider = new CompatibilityBuildProvider();
        }
        return this.mProvider;
    }
}

