/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.util.ChecksumReporter;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestStatus;
import com.android.tradefed.result.suite.XmlSuiteResultFormatter;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CertificationChecksumHelper {
    public static final String NAME = "checksum-suite.data";
    private static final double DEFAULT_FPP = 0.05;
    private static final String SEPARATOR = "/";
    private static final short CURRENT_VERSION = 1;
    static final short SERIALIZED_FORMAT_CODE = 650;
    private final BloomFilter<CharSequence> mResultChecksum;
    private final HashMap<String, byte[]> mFileChecksum;
    private final short mVersion;
    private final String mBuildFingerprint;

    public CertificationChecksumHelper(int totalCount, double fpp, short version, String buildFingerprint) {
        this.mResultChecksum = BloomFilter.create((Funnel)Funnels.unencodedCharsFunnel(), (int)totalCount, (double)fpp);
        this.mFileChecksum = new HashMap();
        this.mVersion = version;
        this.mBuildFingerprint = buildFingerprint;
    }

    public static boolean tryCreateChecksum(File dir, Collection<TestRunResult> results, String buildFingerprint) {
        try {
            int totalCount = results.size() * 2 + CertificationChecksumHelper.countTestResults(results);
            CertificationChecksumHelper checksumReporter = new CertificationChecksumHelper(totalCount, 0.05, 1, buildFingerprint);
            checksumReporter.addResults(results);
            checksumReporter.addDirectory(dir);
            checksumReporter.saveToFile(dir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void saveToFile(File directory) throws IOException {
        File file = new File(directory, NAME);
        try (FileOutputStream fileStream = new FileOutputStream(file, false);
             BufferedOutputStream outputStream = new BufferedOutputStream(fileStream);
             ObjectOutputStream objectOutput = new ObjectOutputStream(outputStream);){
            objectOutput.writeShort(650);
            objectOutput.writeShort(this.mVersion);
            objectOutput.writeObject(this.mResultChecksum);
            objectOutput.writeObject(this.mFileChecksum);
        }
    }

    private static int countTestResults(Collection<TestRunResult> results) {
        int count = 0;
        for (TestRunResult result : results) {
            count += result.getNumTests();
        }
        return count;
    }

    private void addResults(Collection<TestRunResult> results) {
        for (TestRunResult moduleResult : results) {
            this.mResultChecksum.put((Object)CertificationChecksumHelper.generateModuleResultSignature(moduleResult, this.mBuildFingerprint));
            this.mResultChecksum.put((Object)CertificationChecksumHelper.generateModuleSummarySignature(moduleResult, this.mBuildFingerprint));
            for (Map.Entry<TestDescription, TestResult> entry : moduleResult.getTestResults().entrySet()) {
                this.mResultChecksum.put((Object)CertificationChecksumHelper.generateTestResultSignature(entry, moduleResult, this.mBuildFingerprint));
            }
        }
    }

    private static String generateModuleResultSignature(TestRunResult module, String buildFingerprint) {
        StringBuilder sb = new StringBuilder();
        sb.append(buildFingerprint).append(SEPARATOR).append(module.getName()).append(SEPARATOR).append(module.isRunComplete()).append(SEPARATOR).append(module.getNumTestsInState(TestStatus.FAILURE));
        return sb.toString();
    }

    private static String generateModuleSummarySignature(TestRunResult module, String buildFingerprint) {
        StringBuilder sb = new StringBuilder();
        sb.append(buildFingerprint).append(SEPARATOR).append(module.getName()).append(SEPARATOR).append(module.getNumTestsInState(TestStatus.FAILURE));
        return sb.toString();
    }

    private static String generateTestResultSignature(Map.Entry<TestDescription, TestResult> testResult, TestRunResult module, String buildFingerprint) {
        StringBuilder sb = new StringBuilder();
        String stacktrace = testResult.getValue().getStackTrace();
        stacktrace = stacktrace == null ? "" : stacktrace.trim();
        stacktrace = XmlSuiteResultFormatter.truncateStackTrace((String)stacktrace, (String)testResult.getKey().getTestName());
        stacktrace = XmlSuiteResultFormatter.sanitizeXmlContent((String)stacktrace);
        stacktrace = stacktrace.replaceAll("\\r?\\n|\\r", "");
        String testResultStatus = TestStatus.convertToCompatibilityString((TestStatus)testResult.getValue().getResultStatus());
        sb.append(buildFingerprint).append(SEPARATOR).append(module.getName()).append(SEPARATOR).append(testResult.getKey().toString()).append(SEPARATOR).append(testResultStatus).append(SEPARATOR).append(stacktrace).append(SEPARATOR);
        return sb.toString();
    }

    public void addDirectory(File directory) {
        this.addDirectory(directory, directory.getName());
    }

    private void addDirectory(File directory, String path) {
        for (String childName : directory.list()) {
            File child = new File(directory, childName);
            if (child.isDirectory()) {
                this.addDirectory(child, path + SEPARATOR + child.getName());
                continue;
            }
            this.addFile(child, path);
        }
    }

    private void addFile(File file, String path) {
        byte[] crc;
        try {
            crc = CertificationChecksumHelper.calculateFileChecksum(file);
        }
        catch (ChecksumReporter.ChecksumValidationException e) {
            crc = new byte[]{};
        }
        String key = path + SEPARATOR + file.getName();
        this.mFileChecksum.put(key, crc);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] calculateFileChecksum(File file) throws ChecksumReporter.ChecksumValidationException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray;
            try (BufferedInputStream inputStream = new BufferedInputStream(fis);){
                int cnt;
                MessageDigest hashSum = MessageDigest.getInstance("SHA-256");
                int bufferSize = 8192;
                byte[] buffer = new byte[bufferSize];
                while ((cnt = ((InputStream)inputStream).read(buffer)) != -1) {
                    hashSum.update(buffer, 0, cnt);
                }
                byte[] partialHash = new byte[32];
                hashSum.digest(partialHash, 0, 32);
                byArray = partialHash;
            }
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumReporter.ChecksumValidationException("Unable to hash file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ChecksumReporter.ChecksumValidationException("Unable to hash file.", (Throwable)e);
        }
        catch (DigestException e) {
            throw new ChecksumReporter.ChecksumValidationException("Unable to hash file.", (Throwable)e);
        }
    }
}

