/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.system;

import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.network.NetworkUtil;

public final class SystemInfoPrinter {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final NetworkUtil networkUtil;

    public SystemInfoPrinter() {
        this(new NetworkUtil());
    }

    private SystemInfoPrinter(NetworkUtil networkUtil) {
        this.networkUtil = networkUtil;
    }

    public void printSystemInfo(LogRecordImportance.Importance importance) {
        try {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, importance)).log("Hostname: %s", this.networkUtil.getLocalHostName());
        }
        catch (MobileHarnessException e) {
            ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, importance)).withCause(e)).log("Failed to get local hostname");
        }
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, importance)).log("System Properties: %s", System.getProperties());
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, importance)).log("Environment Variables: %s", System.getenv());
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, importance)).log("Java version: %s", Runtime.version());
    }
}

