/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.system;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.devtools.mobileharness.shared.util.base.StrUtil;
import com.google.devtools.mobileharness.shared.util.system.AutoValue_MemoryInfo;

@AutoValue
public abstract class MemoryInfo {
    public abstract long jvmFreeMemory();

    public abstract long jvmTotalMemory();

    public abstract long jvmMaxMemory();

    public abstract long heapUsedMemory();

    public abstract long freeMemory();

    public abstract long totalMemory();

    @Memoized
    public long jvmUsedMemory() {
        return this.jvmTotalMemory() - this.jvmFreeMemory();
    }

    @Memoized
    public long usedMemory() {
        return this.totalMemory() - this.freeMemory();
    }

    @Memoized
    public String toString() {
        return String.format("jvm_used=%s, jvm_total=%s, jvm_max=%s, heap_used=%s, free=%s, used=%s, total=%s", StrUtil.getHumanReadableSize(this.jvmUsedMemory()), StrUtil.getHumanReadableSize(this.jvmTotalMemory()), StrUtil.getHumanReadableSize(this.jvmMaxMemory()), StrUtil.getHumanReadableSize(this.heapUsedMemory()), StrUtil.getHumanReadableSize(this.freeMemory()), StrUtil.getHumanReadableSize(this.usedMemory()), StrUtil.getHumanReadableSize(this.totalMemory()));
    }

    public static MemoryInfo of(long jvmFreeMemory, long jvmTotalMemory, long jvmMaxMemory, long heapUsedMemory, long freeMemory, long totalMemory) {
        return new AutoValue_MemoryInfo(jvmFreeMemory, jvmTotalMemory, jvmMaxMemory, heapUsedMemory, freeMemory, totalMemory);
    }
}

