/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.message;

import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldMask;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldMaskUtils {
    public static Optional<FieldMask> subFieldMask(FieldMask fieldMask, Descriptors.FieldDescriptor fieldDescriptor, Descriptors.FieldDescriptor ... otherFieldDescriptors) {
        String pathPrefix = Stream.concat(Stream.of(fieldDescriptor), Arrays.stream(otherFieldDescriptors)).map(Descriptors.FieldDescriptor::getName).collect(Collectors.joining("."));
        String pathPrefixWithDot = pathPrefix + ".";
        FieldMask.Builder result = FieldMask.newBuilder();
        for (String path : fieldMask.getPathsList()) {
            if (path.equals(pathPrefix) || pathPrefix.startsWith(path) && pathPrefix.charAt(path.length()) == '.') {
                return Optional.empty();
            }
            if (!path.startsWith(pathPrefixWithDot)) continue;
            result.addPaths(path.substring(pathPrefixWithDot.length()));
        }
        return Optional.of(result.build());
    }

    public static String createFieldMaskPath(Descriptors.FieldDescriptor ... fields) {
        return Arrays.stream(fields).map(Descriptors.FieldDescriptor::getName).collect(Collectors.joining("."));
    }

    private FieldMaskUtils() {
    }
}

