/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.logging;

import com.google.common.flogger.LogContext;
import com.google.common.flogger.LogSite;
import com.google.common.flogger.LogSites;
import com.google.common.flogger.MetadataKey;
import com.google.common.flogger.backend.system.AbstractLogRecord;
import com.google.common.flogger.context.Tags;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;

public class LogDataExtractor {
    @Nullable
    public static <T> T getSingleMetadataValue(LogRecord record, MetadataKey<T> key) {
        if (record instanceof AbstractLogRecord) {
            return ((AbstractLogRecord)record).getMetadataProcessor().getSingleValue(key);
        }
        return null;
    }

    public static LogSite getLogSite(LogRecord record) {
        if (record instanceof AbstractLogRecord) {
            return ((AbstractLogRecord)record).getLogData().getLogSite();
        }
        if (record.getSourceClassName() != null && record.getSourceMethodName() != null) {
            return LogSites.logSiteFrom(new StackTraceElement(record.getSourceClassName(), record.getSourceMethodName(), null, 0));
        }
        return LogSite.INVALID;
    }

    public static Tags getTags(LogRecord record) {
        Tags tags;
        if (record instanceof AbstractLogRecord && (tags = ((AbstractLogRecord)record).getMetadataProcessor().getSingleValue(LogContext.Key.TAGS)) != null) {
            return tags;
        }
        return Tags.empty();
    }

    private LogDataExtractor() {
    }
}

