/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.error;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MoreThrowables {
    public static String formatStackTraces() {
        Thread currentThread = Thread.currentThread();
        return Thread.getAllStackTraces().entrySet().stream().filter(threadEntry -> !((Thread)threadEntry.getKey()).equals(currentThread)).sorted(Comparator.comparing(threadEntry -> ((Thread)threadEntry.getKey()).getName())).map(MoreThrowables::formatThread).collect(Collectors.joining("\n\n"));
    }

    private static String formatThread(Map.Entry<Thread, StackTraceElement[]> threadEntry) {
        StringBuilder result = new StringBuilder();
        result.append(threadEntry.getKey());
        for (StackTraceElement stackTraceElement : threadEntry.getValue()) {
            result.append("\n\t");
            result.append(stackTraceElement);
        }
        return result.toString();
    }

    public static String shortDebugString(Throwable e) {
        return MoreThrowables.shortDebugString(e, 0);
    }

    public static String shortDebugString(Throwable e, int maxLength) {
        StringBuilder result = new StringBuilder();
        boolean checkLength = maxLength > 0;
        while (true) {
            result.append(e.getMessage());
            if (checkLength && --maxLength == 0 || (e = e.getCause()) == null) break;
            result.append(", cause: ");
        }
        return result.toString();
    }

    public static String shortDebugCurrentStackTrace(long maxLength) {
        return MoreThrowables.shortDebugCurrentStackTrace(maxLength, 1L);
    }

    public static String shortDebugCurrentStackTrace(long maxLength, long skip) {
        return MoreThrowables.shortDebugStackTrace(Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L + skip), maxLength);
    }

    public static String shortDebugStackTrace(Thread thread, long maxLength) {
        return MoreThrowables.shortDebugStackTrace(Arrays.stream(thread.getStackTrace()), maxLength);
    }

    public static String shortDebugStackTrace(Throwable throwable, long maxLength) {
        return MoreThrowables.shortDebugStackTrace(Arrays.stream(throwable.getStackTrace()), maxLength);
    }

    private static String shortDebugStackTrace(Stream<StackTraceElement> stackTrace, long maxLength) {
        return stackTrace.limit(maxLength <= 0L ? Long.MAX_VALUE : maxLength).map(StackTraceElement::toString).collect(Collectors.joining("  <--  ", "[", "]"));
    }

    private MoreThrowables() {
    }
}

