/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.concurrent;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.mobileharness.shared.context.InvocationContextExecutors;
import com.google.devtools.mobileharness.shared.util.concurrent.ThreadFactoryUtil;
import java.util.concurrent.Executors;

public class ThreadPools {
    public static ListeningExecutorService createStandardThreadPool(String threadNamePrefix) {
        return InvocationContextExecutors.propagatingContext(MoreExecutors.listeningDecorator(Executors.newCachedThreadPool(ThreadFactoryUtil.createThreadFactory(threadNamePrefix, true))), ListeningExecutorService.class);
    }

    public static ListeningScheduledExecutorService createStandardScheduledThreadPool(String threadNamePrefix, int corePoolSize) {
        return InvocationContextExecutors.propagatingContext(MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(corePoolSize, ThreadFactoryUtil.createThreadFactory(threadNamePrefix, true))), ListeningScheduledExecutorService.class);
    }

    private ThreadPools() {
    }
}

