/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.io;

import com.google.common.io.ByteSink;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LineReader
extends ByteSink {
    private static final int READ_BUFFER_SIZE = 512;
    private StringBuilder line = new StringBuilder();
    private boolean sawReturn;
    private boolean stopHandling;
    private final PipedOutputStream outputStream;
    private final Reader reader;
    private final char[] readBuffer = new char[512];

    public LineReader() {
        this.outputStream = new PipedOutputStream();
        try {
            this.reader = new InputStreamReader((InputStream)new PipedInputStream(this.outputStream), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public OutputStream openStream() {
        return this.outputStream;
    }

    public void start(LineHandler lineHandler) throws IOException {
        try {
            int count;
            while ((count = this.reader.read(this.readBuffer)) != -1) {
                if (this.stopHandling) continue;
                this.add(count, lineHandler);
            }
            this.finish(lineHandler);
        }
        finally {
            lineHandler.onSourceClosed();
        }
    }

    private void add(int len, LineHandler lineHandler) {
        int pos = 0;
        if (this.sawReturn && len > 0 && this.finishLine(this.readBuffer[pos] == '\n', lineHandler)) {
            ++pos;
        }
        int start = pos;
        while (pos < len) {
            switch (this.readBuffer[pos]) {
                case '\r': {
                    this.line.append(this.readBuffer, start, pos - start);
                    this.sawReturn = true;
                    if (pos + 1 < len && this.finishLine(this.readBuffer[pos + 1] == '\n', lineHandler)) {
                        ++pos;
                    }
                    start = pos + 1;
                    break;
                }
                case '\n': {
                    this.line.append(this.readBuffer, start, pos - start);
                    this.finishLine(true, lineHandler);
                    start = pos + 1;
                    break;
                }
            }
            ++pos;
        }
        this.line.append(this.readBuffer, start, len - start);
    }

    @CanIgnoreReturnValue
    private boolean finishLine(boolean sawNewline, LineHandler lineHandler) {
        String separator;
        String string = this.sawReturn ? (sawNewline ? "\r\n" : "\r") : (separator = sawNewline ? "\n" : "");
        if (!this.stopHandling) {
            this.stopHandling = lineHandler.handleLine(this.line.toString(), separator);
        }
        this.line = new StringBuilder();
        this.sawReturn = false;
        return sawNewline;
    }

    private void finish(LineHandler lineHandler) {
        if (this.sawReturn || this.line.length() > 0) {
            this.finishLine(false, lineHandler);
        }
    }

    static interface LineHandler {
        public boolean handleLine(String var1, String var2);

        public void onSourceClosed();
    }
}

