/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.backend;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.devtools.mobileharness.shared.util.command.backend.AutoValue_InputSource;
import com.google.errorprone.annotations.Immutable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class InputSource {
    private static final InputSource FROM_JVM = InputSource.create(Kind.JVM, Optional.empty());
    private static final InputSource FROM_PROCESS = InputSource.create(Kind.PROCESS, Optional.empty());

    public static InputSource fromFile(Path file) {
        return InputSource.create(Kind.FILE, Optional.of(file));
    }

    public static InputSource fromJvm() {
        return FROM_JVM;
    }

    public static InputSource fromProcess() {
        return FROM_PROCESS;
    }

    public static InputSource fromStream(ByteSource byteSource) {
        return InputSource.create(Kind.STREAM, Optional.of(byteSource));
    }

    private static InputSource create(Kind kind2, Optional<Object> parameter) {
        return new AutoValue_InputSource(kind2, parameter);
    }

    InputSource() {
    }

    public abstract Kind kind();

    public final Path file() {
        Preconditions.checkState(this.kind().equals((Object)Kind.FILE), "Source is %s, not a file.", (Object)this.kind());
        return (Path)this.parameter().get();
    }

    public final ByteSource streamSupplier() {
        Preconditions.checkState(this.kind().equals((Object)Kind.STREAM), "Source is %s, not a stream.", (Object)this.kind());
        return (ByteSource)this.parameter().get();
    }

    abstract Optional<Object> parameter();

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(InputSource.class).add("kind", (Object)this.kind());
        if (this.parameter().isPresent()) {
            helper.addValue(this.parameter().get());
        }
        return helper.toString();
    }

    final InputStream openStream() throws IOException {
        switch (this.kind().ordinal()) {
            case 0: {
                return Files.newInputStream(this.file(), new OpenOption[0]);
            }
            case 1: {
                return new FilterInputStream(new FileInputStream(FileDescriptor.in)){

                    @Override
                    public void close() {
                    }
                };
            }
            case 2: {
                throw new IllegalStateException("No input stream available when reading from a process stream");
            }
            case 3: {
                return this.streamSupplier().openStream();
            }
        }
        throw new AssertionError((Object)this.kind());
    }

    public static enum Kind {
        FILE,
        JVM,
        PROCESS,
        STREAM;

    }
}

