/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.backend;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.devtools.mobileharness.shared.util.command.backend.Command;
import com.google.devtools.mobileharness.shared.util.command.backend.CommandException;
import com.google.devtools.mobileharness.shared.util.command.backend.CommandResult;

public final class CommandFailureException
extends CommandException {
    private final CommandResult result;

    CommandFailureException(Command command, CommandResult result) {
        super(command, Preconditions.checkNotNull(result, command).toString());
        if (this.command().successCondition().test(result)) {
            throw new AssertionError((Object)Strings.lenientFormat("%s incorrectly passed a result which passes the command's success condition.\nCommand: %s\nResult: %s", this.getClass().getName(), this.command(), result));
        }
        this.result = result;
    }

    public CommandResult result() {
        return this.result;
    }
}

