/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.common.base.StandardSystemProperty;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.shared.util.command.Command;
import java.util.Objects;

class CommandBugChecker {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    CommandBugChecker() {
    }

    void checkCommand(Command command) {
        if (command.getExecutable().equals("sudo") && !this.isRunAsRoot()) {
            ((FluentLogger.Api)logger.atWarning()).log("Command [%s] uses sudo however the current process does not run as root, which may cause the command to keep hanging until timeout and then throw out InterruptedException", command);
        }
    }

    private boolean isRunAsRoot() {
        String userName = System.getenv("USER");
        if (userName != null && !userName.isEmpty()) {
            return userName.equals("root");
        }
        return Objects.equals(StandardSystemProperty.USER_NAME.value(), "root");
    }
}

