/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.devtools.mobileharness.shared.util.command.Timeout;
import com.google.devtools.mobileharness.shared.util.time.CountDownTimer;
import java.time.Duration;
import java.util.Optional;

final class AutoValue_Timeout
extends Timeout {
    private final Optional<Duration> period;
    private final Optional<CountDownTimer> deadline;

    private AutoValue_Timeout(Optional<Duration> period, Optional<CountDownTimer> deadline) {
        this.period = period;
        this.deadline = deadline;
    }

    @Override
    public Optional<Duration> getPeriod() {
        return this.period;
    }

    @Override
    public Optional<CountDownTimer> getDeadline() {
        return this.deadline;
    }

    public String toString() {
        return "Timeout{period=" + String.valueOf(this.period) + ", deadline=" + String.valueOf(this.deadline) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Timeout) {
            Timeout that = (Timeout)o;
            return this.period.equals(that.getPeriod()) && this.deadline.equals(that.getDeadline());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.period.hashCode();
        h$ *= 1000003;
        return h$ ^= this.deadline.hashCode();
    }

    @Override
    Timeout.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Timeout.Builder {
        private Optional<Duration> period = Optional.empty();
        private Optional<CountDownTimer> deadline = Optional.empty();

        Builder() {
        }

        private Builder(Timeout source) {
            this.period = source.getPeriod();
            this.deadline = source.getDeadline();
        }

        @Override
        Timeout.Builder period(Duration period) {
            this.period = Optional.of(period);
            return this;
        }

        @Override
        Timeout.Builder deadline(CountDownTimer deadline) {
            this.deadline = Optional.of(deadline);
            return this;
        }

        @Override
        Timeout autoBuild() {
            return new AutoValue_Timeout(this.period, this.deadline);
        }
    }
}

