/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class StrUtil {
    public static final int MAX_TAILING_LINES = 50;
    public static final String DEFAULT_ENTRY_DELIMITER = ",";
    public static final String DEFAULT_KEY_VALUE_DELIMITER = "=";
    public static final Joiner.MapJoiner DEFAULT_MAP_JOINER = Joiner.on(",").withKeyValueSeparator("=");
    public static final int DEFAULT_LINE_LENGTH = 80;
    private static final String INVALID_MAP_ENTRY_MSG_TEMPLATE = "Chunk [%s] is not a valid entry";
    private static final String DEFAULT_DELIMITER = ",";
    private static final Splitter TO_WORDS = Splitter.on(CharMatcher.breakingWhitespace()).omitEmptyStrings();

    @Nullable
    public static String tail(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int idx = str.lastIndexOf(10);
        int lineCount = 0;
        while (idx >= 0 && ++lineCount <= 50) {
            idx = str.lastIndexOf(10, idx - 1);
        }
        if (idx < 0) {
            return str;
        }
        return "(...only show last 50 lines...)\n" + str.substring(idx + 1);
    }

    public static Map<String, String> toMap(@Nullable String string) {
        return StrUtil.toMap(string, ",", DEFAULT_KEY_VALUE_DELIMITER, false);
    }

    public static Map<String, String> toMap(@Nullable String string, boolean allowDelimiterInValue) {
        return StrUtil.toMap(string, ",", DEFAULT_KEY_VALUE_DELIMITER, allowDelimiterInValue);
    }

    public static Map<String, String> toMap(@Nullable String string, String keyValueDelimiter) {
        return StrUtil.toMap(string, ",", keyValueDelimiter, false);
    }

    public static Map<String, String> toMap(@Nullable String string, String keyValueDelimiter, boolean allowDelimiterInValue) {
        return StrUtil.toMap(string, ",", keyValueDelimiter, allowDelimiterInValue);
    }

    public static Map<String, String> toMap(@Nullable String string, String entryDelimiter, String keyValueDelimiter) {
        return StrUtil.toMap(string, entryDelimiter, keyValueDelimiter, false);
    }

    public static Map<String, String> toMap(@Nullable String string, String entryDelimiter, String keyValueDelimiter, boolean allowDelimiterInValue) {
        if (Strings.isNullOrEmpty(string)) {
            return ImmutableMap.of();
        }
        Splitter keyValueSplitter = Splitter.on(keyValueDelimiter).trimResults();
        if (allowDelimiterInValue) {
            keyValueSplitter = keyValueSplitter.limit(2);
        }
        Splitter.MapSplitter mapSplitter = Splitter.on(entryDelimiter).trimResults().omitEmptyStrings().withKeyValueSeparator(keyValueSplitter);
        return mapSplitter.split(string);
    }

    public static Map<String, String> toMap(@Nullable String string, String entryDelimiter, String keyValueDelimiter, boolean allowDelimiterInValue, boolean isValueOptional) {
        return StrUtil.toMap(string, entryDelimiter, keyValueDelimiter, allowDelimiterInValue, isValueOptional, false);
    }

    public static Map<String, String> toMap(@Nullable String string, String entryDelimiter, String keyValueDelimiter, boolean allowDelimiterInValue, boolean isValueOptional, boolean ignoreInvalidEntries) {
        if (Strings.isNullOrEmpty(string)) {
            return ImmutableMap.of();
        }
        Splitter keyValueSplitter = Splitter.on(keyValueDelimiter).trimResults();
        if (allowDelimiterInValue) {
            keyValueSplitter = keyValueSplitter.limit(2);
        }
        Splitter entrySplitter = Splitter.on(entryDelimiter).trimResults().omitEmptyStrings();
        List<String> entries = entrySplitter.splitToList(string);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String entry : entries) {
            if (ignoreInvalidEntries && !entry.contains(keyValueDelimiter)) continue;
            Iterator<String> keyValue = keyValueSplitter.split(entry).iterator();
            Preconditions.checkArgument(keyValue.hasNext(), INVALID_MAP_ENTRY_MSG_TEMPLATE, (Object)entry);
            String key = keyValue.next();
            Preconditions.checkArgument(!map.containsKey(key), "Duplicate key [%s] found.", (Object)key);
            if (isValueOptional && !keyValue.hasNext()) {
                map.put(key, null);
            } else {
                Preconditions.checkArgument(keyValue.hasNext(), INVALID_MAP_ENTRY_MSG_TEMPLATE, (Object)entry);
                String value = keyValue.next();
                map.put(key, value);
            }
            Preconditions.checkArgument(!keyValue.hasNext(), INVALID_MAP_ENTRY_MSG_TEMPLATE, (Object)entry);
        }
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, List<String>> toMultimap(@Nullable String string, String entryDelimiter, String keyValueDelimiter, boolean allowDelimiterInValue, @Nullable String defaultKey) {
        if (Strings.isNullOrEmpty(string)) {
            return ImmutableMap.of();
        }
        Splitter keyValueSplitter = Splitter.on(keyValueDelimiter).trimResults();
        if (allowDelimiterInValue) {
            keyValueSplitter = keyValueSplitter.limit(2);
        }
        Splitter entrySplitter = Splitter.on(entryDelimiter).trimResults().omitEmptyStrings();
        List<String> entries = entrySplitter.splitToList(string);
        LinkedHashMap<String, List> multiMap = new LinkedHashMap<String, List>();
        for (String entry : entries) {
            Iterator<String> keyValue = keyValueSplitter.split(entry).iterator();
            Preconditions.checkArgument(keyValue.hasNext(), INVALID_MAP_ENTRY_MSG_TEMPLATE, (Object)entry);
            String key = defaultKey;
            String value = keyValue.next();
            if (keyValue.hasNext()) {
                key = value;
                value = keyValue.next();
            }
            if (Strings.isNullOrEmpty(key)) continue;
            List values = multiMap.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
            Preconditions.checkArgument(!keyValue.hasNext(), INVALID_MAP_ENTRY_MSG_TEMPLATE, (Object)entry);
        }
        return Collections.unmodifiableMap(multiMap);
    }

    public static String addFrame(String message) {
        return StrUtil.addFrame(message, 80);
    }

    public static String addFrame(String message, int maxWidth) {
        if (message.isEmpty()) {
            return message;
        }
        List<String> lines = Splitter.on('\n').splitToList(message);
        int maxLength = -1;
        for (String line : lines) {
            maxLength = Math.max(maxLength, line.length());
        }
        int margin = 3;
        maxLength = Math.min(maxLength, maxWidth - margin * 2);
        ArrayList<Object> res = new ArrayList<Object>();
        res.add("");
        res.add("*".repeat(maxLength + margin * 2));
        res.add("*" + " ".repeat(maxLength + (margin - 1) * 2) + "*");
        for (String line : lines) {
            if (line.length() > maxLength) {
                for (String subLine : Splitter.on("\n").split(StrUtil.formatLineToFixedWidth(line, maxLength))) {
                    res.add(String.format("*  %-" + maxLength + "s  *", subLine));
                }
                continue;
            }
            res.add(String.format("*  %-" + maxLength + "s  *", line));
        }
        res.add("*" + " ".repeat(maxLength + (margin - 1) * 2) + "*");
        res.add("*".repeat(maxLength + margin * 2));
        return Joiner.on('\n').join(res);
    }

    public static long parseHumanReadableSize(String s2) {
        int originalLength = 0;
        int newLength = 0;
        long multiple = 1L;
        if (s2 != null) {
            originalLength = s2.length();
            newLength = originalLength;
            if (newLength > 0 && (s2.charAt(newLength - 1) == 'B' || s2.charAt(newLength - 1) == 'b')) {
                --newLength;
            }
            if (newLength > 0) {
                switch (s2.charAt(newLength - 1)) {
                    case 'G': 
                    case 'g': {
                        --newLength;
                        multiple = 0x40000000L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        --newLength;
                        multiple = 0x100000L;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        --newLength;
                        multiple = 1024L;
                        break;
                    }
                }
            }
        }
        if (newLength < originalLength) {
            s2 = s2.substring(0, newLength);
        }
        return multiple == 1L ? Long.parseLong(s2) : (long)(Double.parseDouble(s2) * (double)multiple);
    }

    public static String getHumanReadableSize(long size) {
        if (size < 1024L) {
            return size + "B";
        }
        double tempSize = (double)size / 1024.0;
        if (tempSize < 1024.0) {
            return StrUtil.getRound(tempSize) + "KB";
        }
        if ((tempSize /= 1024.0) < 1024.0) {
            return StrUtil.getRound(tempSize) + "MB";
        }
        return StrUtil.getRound(tempSize / 1024.0) + "GB";
    }

    private static String getRound(double size) {
        long roundedSize = Math.round(size);
        if (size < 100.0) {
            if (size == (double)roundedSize) {
                return Long.toString(roundedSize);
            }
            return Double.toString((double)Math.round(size * 100.0) / 100.0);
        }
        return Long.toString(roundedSize);
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static Set<Character> toCharSet(String s2) {
        HashSet<Character> charSet = new HashSet<Character>();
        for (int i = 0; i < s2.length(); ++i) {
            char character = s2.charAt(i);
            charSet.add(Character.valueOf(character));
        }
        return charSet;
    }

    public static List<String> toList(@Nullable String str) {
        return StrUtil.toList(str, ",");
    }

    public static List<String> toList(@Nullable String str, String delimiter) {
        if (Strings.isNullOrEmpty(str)) {
            return ImmutableList.of();
        }
        return Splitter.on(delimiter).trimResults().omitEmptyStrings().splitToList(str);
    }

    public static boolean isEmptyOrWhitespace(@CheckForNull String string) {
        return string == null || CharMatcher.whitespace().matchesAllOf(string);
    }

    @CheckForNull
    public static String stripPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : null;
    }

    public static String truncateAtMaxLength(String source, int maxLength, boolean addEllipsis) {
        if (source.length() <= maxLength) {
            return source;
        }
        if (addEllipsis && maxLength > 3) {
            return StrUtil.unicodePreservingSubstring(source, 0, maxLength - 3) + "...";
        }
        return StrUtil.unicodePreservingSubstring(source, 0, maxLength);
    }

    public static String unicodePreservingSubstring(String str, int begin, int end) {
        return str.substring(StrUtil.unicodePreservingIndex(str, begin), StrUtil.unicodePreservingIndex(str, end));
    }

    static int unicodePreservingIndex(String str, int index) {
        if (index > 0 && index < str.length() && Character.isHighSurrogate(str.charAt(index - 1)) && Character.isLowSurrogate(str.charAt(index))) {
            return index - 1;
        }
        return index;
    }

    private static String formatLineToFixedWidth(String line, int width) {
        if (line.length() <= width) {
            return line;
        }
        StringBuilder builder = new StringBuilder();
        int col = 0;
        for (String word : TO_WORDS.split(line)) {
            if (col == 0) {
                col = word.length();
            } else {
                int newCol = col + word.length() + 1;
                if (newCol <= width) {
                    builder.append(' ');
                    col = newCol;
                } else {
                    builder.append('\n');
                    col = word.length();
                }
            }
            builder.append(word);
        }
        return builder.toString();
    }

    private StrUtil() {
    }
}

