/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.base;

import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class ProtoReflectionUtil {
    public static boolean isGeneratedClass(Class<? extends Message> protoClazz) {
        return Message.class.isAssignableFrom(protoClazz) && Arrays.stream(protoClazz.getMethods()).anyMatch(method -> method.getName().equals("getDefaultInstance") && method.getParameterCount() == 0);
    }

    public static <T extends MessageLite> T getDefaultInstance(Class<T> protoClazz) {
        try {
            Method method = protoClazz.getMethod("getDefaultInstance", new Class[0]);
            return (T)((MessageLite)method.invoke((Object)method, new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError("Failed to get default instance for " + String.valueOf(protoClazz), e);
        }
    }

    public static <B extends Message.Builder> B newInstance(Class<? extends Message> protoClazz, Class<B> builderClazz) {
        try {
            return (B)((Message.Builder)builderClazz.cast(protoClazz.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0])));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError("Failed to call newBuilder() on %s" + String.valueOf(protoClazz), e);
        }
    }

    private ProtoReflectionUtil() {
    }
}

