/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite.subplan;

import com.google.devtools.mobileharness.api.model.error.ExtErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlParser {
    public void parse(InputStream xmlInput) throws MobileHarnessException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            DefaultHandler handler = this.createXmlHandler();
            parser.parse(new InputSource(xmlInput), handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MobileHarnessException(ExtErrorId.ABSTRACT_XML_PARSER_PARSE_XML_ERROR, "Failed to parse xml", e);
        }
    }

    protected abstract DefaultHandler createXmlHandler();
}

