/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite;

import com.google.auto.value.AutoValue;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.infra.ats.common.plan.JarFileUtil;
import com.google.devtools.mobileharness.platform.android.xts.suite.AutoValue_TestSuiteInfoProvider_CacheKey;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfo;
import java.util.concurrent.ExecutionException;

public final class TestSuiteInfoProvider {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final LoadingCache<CacheKey, TestSuiteInfo> cache = CacheBuilder.newBuilder().maximumSize(1000L).build(new CacheLoader<CacheKey, TestSuiteInfo>(){

        @Override
        public TestSuiteInfo load(CacheKey key) {
            ((FluentLogger.Api)logger.atFine()).log("Creating %s instance with params [xts root dir: %s, xts type: %s]", TestSuiteInfo.class.getSimpleName(), key.xtsRootDir(), key.xtsType());
            return new TestSuiteInfo(key.xtsRootDir(), key.xtsType(), new JarFileUtil());
        }
    });

    public static TestSuiteInfo getTestSuiteInfo(String xtsRootDir, String xtsType) {
        try {
            return cache.get(CacheKey.create(xtsRootDir, xtsType));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(String.format("Error loading test suite info for xts root dir \"%s\" and xts type \"%s\"", xtsRootDir, xtsType), e);
        }
    }

    private TestSuiteInfoProvider() {
    }

    @AutoValue
    static abstract class CacheKey {
        CacheKey() {
        }

        abstract String xtsRootDir();

        abstract String xtsType();

        static CacheKey create(String xtsRootDir, String xtsType) {
            return new AutoValue_TestSuiteInfoProvider_CacheKey(xtsRootDir, xtsType);
        }
    }
}

