/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite;

import com.google.common.base.Splitter;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.infra.ats.common.plan.JarFileUtil;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class TestSuiteInfo {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String SUITE_INFO_PROPERTY = "test-suite-info.properties";
    private static final String BUILD_NUMBER = "build_number";
    private static final String TARGET_ARCH = "target_arch";
    private static final String NAME = "name";
    private static final String FULLNAME = "fullname";
    private static final String VERSION = "version";
    private Properties testSuiteInfoProps;
    private final JarFileUtil jarFileUtil;
    private final String xtsRootDir;
    private final String xtsTypeStr;

    TestSuiteInfo(String xtsRootDir, String xtsType, JarFileUtil jarFileUtil) {
        this.jarFileUtil = jarFileUtil;
        this.xtsRootDir = xtsRootDir;
        this.xtsTypeStr = xtsType;
        this.loadSuiteInfo();
    }

    private void loadSuiteInfo() {
        Path xtsTfJar = this.getToolsDir().resolve(String.format("%s-tradefed.jar", this.xtsTypeStr));
        try {
            Optional<InputStream> testSuiteInfoPropsInputStream = this.jarFileUtil.getZipEntryInputStream(xtsTfJar, SUITE_INFO_PROPERTY);
            if (testSuiteInfoPropsInputStream.isEmpty()) {
                ((FluentLogger.Api)logger.atWarning()).log("Unable to load suite info from jar resource %s, using stub info instead", SUITE_INFO_PROPERTY);
                this.testSuiteInfoProps = new Properties();
                this.testSuiteInfoProps.setProperty(BUILD_NUMBER, "[stub build number]");
                this.testSuiteInfoProps.setProperty(TARGET_ARCH, "[stub target arch]");
                this.testSuiteInfoProps.setProperty(NAME, "[stub name]");
                this.testSuiteInfoProps.setProperty(FULLNAME, "[stub fullname]");
                this.testSuiteInfoProps.setProperty(VERSION, "[stub version]");
            } else {
                this.testSuiteInfoProps = this.loadSuiteInfoFromInputStream(testSuiteInfoPropsInputStream.get());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error loading jar resource file \"%s\" for test suite info from the jar \"%s\"", SUITE_INFO_PROPERTY, xtsTfJar), e);
        }
    }

    private Properties loadSuiteInfoFromInputStream(InputStream testSuiteInfoPropsInputStream) throws IOException {
        Properties props = new Properties();
        props.load(testSuiteInfoPropsInputStream);
        return props;
    }

    public String getBuildNumber() {
        return this.testSuiteInfoProps.getProperty(BUILD_NUMBER);
    }

    public List<String> getTargetArchs() {
        String testSuiteInfoArch = this.testSuiteInfoProps.getProperty(TARGET_ARCH);
        return Splitter.on(",").trimResults().omitEmptyStrings().splitToList(testSuiteInfoArch);
    }

    public String getName() {
        return this.testSuiteInfoProps.getProperty(NAME);
    }

    public String getFullName() {
        return this.testSuiteInfoProps.getProperty(FULLNAME);
    }

    public String getVersion() {
        return this.testSuiteInfoProps.getProperty(VERSION);
    }

    public String get(String name) {
        return this.testSuiteInfoProps.getProperty(name);
    }

    public Path getToolsDir() {
        return XtsDirUtil.getXtsToolsDir(Path.of(this.xtsRootDir, new String[0]), this.xtsTypeStr);
    }
}

