/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.common;

import com.google.devtools.mobileharness.infra.ats.console.result.proto.ResultProto;

public enum TestStatus {
    FAILURE,
    PASSED,
    INCOMPLETE,
    ASSUMPTION_FAILURE,
    IGNORED,
    SKIPPED,
    WARNING;


    public static String convertToTestStatusCompatibilityString(TestStatus status) {
        switch (status.ordinal()) {
            case 1: {
                return "pass";
            }
            case 0: {
                return "fail";
            }
        }
        return status.toString();
    }

    public static TestStatus convertFromTestStatusCompatibilityString(String status) {
        switch (status) {
            case "pass": {
                return PASSED;
            }
            case "fail": {
                return FAILURE;
            }
        }
        return TestStatus.valueOf(status);
    }

    public static String convertMoblyResultToTestStatusCompatibilityString(ResultProto.MoblyResult moblyResult) {
        switch (moblyResult) {
            case PASS: {
                return "pass";
            }
            case FAIL: 
            case ERROR: {
                return "fail";
            }
            case SKIP: {
                return IGNORED.toString();
            }
            case NULL: {
                return INCOMPLETE.toString();
            }
        }
        return moblyResult.toString();
    }
}

