/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.grpc;

import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcStubUtil;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.SessionServiceGrpc;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.SessionServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.SessionStub;
import com.google.devtools.mobileharness.shared.util.comm.stub.Stubs;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.time.Duration;

public class SessionGrpcStub
implements SessionStub {
    private final SessionServiceGrpc.SessionServiceBlockingStub sessionServiceBlockingStub;
    private final SessionServiceGrpc.SessionServiceStub sessionServiceStub;

    public SessionGrpcStub(Channel channel) {
        this.sessionServiceBlockingStub = SessionServiceGrpc.newBlockingStub(channel);
        this.sessionServiceStub = SessionServiceGrpc.newStub(channel);
    }

    @Override
    public SessionServiceProto.CreateSessionResponse createSession(SessionServiceProto.CreateSessionRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofMinutes(2L))::createSession, request, InfraErrorId.OLCS_STUB_CREATE_SESSION_ERROR, "Failed to create session");
    }

    @Override
    public SessionServiceProto.RunSessionResponse runSession(SessionServiceProto.RunSessionRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofMinutes(2L))::runSession, request, InfraErrorId.OLCS_STUB_RUN_SESSION_ERROR, "Failed to run session");
    }

    @Override
    public SessionServiceProto.GetSessionResponse getSession(SessionServiceProto.GetSessionRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofSeconds(40L))::getSession, request, InfraErrorId.OLCS_STUB_GET_SESSION_ERROR, "Failed to get session");
    }

    @Override
    public SessionServiceProto.GetAllSessionsResponse getAllSessions(SessionServiceProto.GetAllSessionsRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofSeconds(40L))::getAllSessions, request, InfraErrorId.OLCS_STUB_GET_ALL_SESSIONS_ERROR, "Failed to get all sessions");
    }

    @Override
    public StreamObserver<SessionServiceProto.SubscribeSessionRequest> subscribeSession(StreamObserver<SessionServiceProto.SubscribeSessionResponse> responseObserver) {
        return this.sessionServiceStub.subscribeSession(responseObserver);
    }

    @Override
    public SessionServiceProto.NotifySessionResponse notifySession(SessionServiceProto.NotifySessionRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofSeconds(40L))::notifySession, request, InfraErrorId.OLCS_STUB_NOTIFY_SESSION_ERROR, "Failed to notify a specific session");
    }

    @Override
    public SessionServiceProto.NotifyAllSessionsResponse notifyAllSessions(SessionServiceProto.NotifyAllSessionsRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofSeconds(40L))::notifyAllSessions, request, InfraErrorId.OLCS_STUB_NOTIFY_SESSION_ERROR, "Failed to notify all sessions ");
    }

    @Override
    public SessionServiceProto.AbortSessionsResponse abortSessions(SessionServiceProto.AbortSessionsRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofSeconds(40L))::abortSessions, request, InfraErrorId.OLCS_STUB_ABORT_SESSIONS_ERROR, "Failed to abort sessions");
    }

    @Override
    public SessionServiceProto.GetSessionManagerStatusResponse getSessionManagerStatus(SessionServiceProto.GetSessionManagerStatusRequest request) throws GrpcExceptionWithErrorId {
        return GrpcStubUtil.invoke(Stubs.withDeadline(this.sessionServiceBlockingStub, Duration.ofSeconds(40L))::getSessionManagerStatus, request, InfraErrorId.OLCS_STUB_GET_SESSION_MANAGER_STATUS_ERROR, "Failed to get session manager status");
    }
}

