/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.version;

import com.google.common.base.Strings;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.infra.ats.console.util.version.VersionParser;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfo;
import com.google.devtools.mobileharness.platform.android.xts.suite.TestSuiteInfoProvider;
import com.google.devtools.mobileharness.shared.version.Version;
import com.google.devtools.mobileharness.shared.version.VersionUtil;
import com.google.devtools.mobileharness.shared.version.proto.VersionProto;
import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Inject;

public class VersionMessageUtil {
    private final ConsoleInfo consoleInfo;
    private final CommandHelper commandHelper;
    private final VersionParser versionParser;

    @Inject
    VersionMessageUtil(ConsoleInfo consoleInfo, CommandHelper commandHelper, VersionParser versionParser) {
        this.consoleInfo = consoleInfo;
        this.commandHelper = commandHelper;
        this.versionParser = versionParser;
    }

    public String getVersionMessage() {
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        String xtsType = this.commandHelper.getXtsType();
        TestSuiteInfo testSuiteInfo = TestSuiteInfoProvider.getTestSuiteInfo(xtsRootDir.toString(), xtsType);
        String buildNumber = this.versionParser.fetchVersion(testSuiteInfo).orElseGet(testSuiteInfo::getBuildNumber);
        String labVersion = Version.LAB_VERSION.toString();
        Optional<VersionProto.BuildVersion> buildVersion = VersionUtil.getBuildVersion();
        return String.format("Android %s %s (%s)\nOmniLab lab-%s%s%s%s%s", testSuiteInfo.getFullName(), testSuiteInfo.getVersion(), buildNumber, labVersion, buildVersion.flatMap(version -> version.getGoogleVersion() == 0L ? Optional.empty() : Optional.of(version.getGoogleVersion())).map(googleVersion -> String.format(" cl/%s", googleVersion)).orElse(""), buildVersion.flatMap(version -> version.getKokoroBuild() == 0L ? Optional.empty() : Optional.of(version.getKokoroBuild())).map(kokoroBuildNumber -> String.format(" kokoro-%s", kokoroBuildNumber)).orElse(""), buildVersion.flatMap(version -> Optional.ofNullable(Strings.emptyToNull(version.getGithubBranch()))).map(githubBranch -> String.format(" branch-%s", githubBranch)).orElse(""), buildVersion.flatMap(version -> Optional.ofNullable(Strings.emptyToNull(version.getGithubVersion()))).map(githubVersion -> String.format(" github-%s", githubVersion)).orElse(""));
    }
}

