/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.result;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.result.proto.ReportProto;
import com.google.devtools.mobileharness.infra.ats.console.result.report.CompatibilityReportParser;
import com.google.devtools.mobileharness.infra.ats.console.util.result.AutoValue_ResultListerHelper_ResultBundle;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import javax.inject.Inject;

public class ResultListerHelper {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final CompatibilityReportParser compatibilityReportParser;
    private final LocalFileUtil localFileUtil;

    @Inject
    ResultListerHelper(CompatibilityReportParser compatibilityReportParser, LocalFileUtil localFileUtil) {
        this.compatibilityReportParser = compatibilityReportParser;
        this.localFileUtil = localFileUtil;
    }

    public ImmutableList<ResultBundle> listResults(String resultsDir) throws MobileHarnessException {
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        ImmutableList resultDirs = Arrays.stream(this.localFileUtil.listDirs(resultsDir)).sorted(Comparator.comparing(File::getName)).collect(ImmutableList.toImmutableList());
        for (File resultDir : resultDirs) {
            if (resultDir.getName().equals("latest")) continue;
            File resultFile = new File(resultDir, "test_result.xml");
            try {
                Optional<ReportProto.Result> result = this.compatibilityReportParser.parse(resultFile.toPath(), true);
                if (result.isEmpty()) {
                    File legacyResultFile = new File(resultDir, String.format("%s/test_result.xml", resultDir.getName()));
                    result = this.compatibilityReportParser.parse(legacyResultFile.toPath(), true);
                }
                result.ifPresent(value -> resultsBuilder.add(ResultBundle.of(resultDir, value)));
            }
            catch (MobileHarnessException e) {
                ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to parse result file: %s", resultFile.getAbsolutePath());
            }
        }
        return resultsBuilder.build();
    }

    public ImmutableList<File> listResultDirsInOrder(String resultsDir) throws MobileHarnessException {
        return this.listResults(resultsDir).stream().map(ResultBundle::resultDir).collect(ImmutableList.toImmutableList());
    }

    @AutoValue
    public static abstract class ResultBundle {
        public static ResultBundle of(File resultDir, ReportProto.Result result) {
            return new AutoValue_ResultListerHelper_ResultBundle(resultDir, result);
        }

        public abstract File resultDir();

        public abstract ReportProto.Result result();
    }
}

