/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.log;

import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleTextStyle;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.LogProto;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LogRecordPrinter {
    private final ConsoleUtil consoleUtil;
    private final int minLogRecordImportance;

    @Inject
    LogRecordPrinter(ConsoleUtil consoleUtil) {
        this.consoleUtil = consoleUtil;
        this.minLogRecordImportance = Flags.instance().atsConsoleOlcServerMinLogRecordImportance.getNonNull();
    }

    public void printLogRecord(LogProto.LogRecord logRecord) {
        if (logRecord.getImportance() >= this.minLogRecordImportance) {
            this.consoleUtil.printlnDirect(logRecord.getFormattedLogRecord(), LogRecordPrinter.getLogRecordStyle(logRecord), System.err);
        }
    }

    private static ConsoleTextStyle getLogRecordStyle(LogProto.LogRecord logRecord) {
        if (logRecord.getSourceType() == LogProto.LogRecord.SourceType.TF) {
            return ConsoleTextStyle.TF_STDOUT;
        }
        return ConsoleTextStyle.OLC_SERVER_LOG;
    }
}

