/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.log;

import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.infra.ats.console.constant.AtsConsoleDirs;
import com.google.devtools.mobileharness.infra.client.longrunningservice.constant.OlcServerDirs;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import java.util.stream.Collectors;

public class LogDumper {
    public static ImmutableList<String> getLogDirs(LogDirsType type) {
        boolean allLogDirs = type == LogDirsType.ALL || Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull() == false;
        return allLogDirs ? ImmutableList.of(OlcServerDirs.getLogDir(), AtsConsoleDirs.getLogDir()) : ImmutableList.of(AtsConsoleDirs.getLogDir());
    }

    public static String dumpLog(LogDirsType type) {
        return LogDumper.getLogDirs(type).stream().map(logDir -> String.format("Saved log to %s/", logDir)).collect(Collectors.joining("\n"));
    }

    private LogDumper() {
    }

    public static enum LogDirsType {
        ALL,
        USED;

    }
}

