/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.command;

import com.google.common.base.Suppliers;
import com.google.devtools.mobileharness.infra.ats.common.XtsTypeLoader;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;

public class CommandHelper {
    private final ConsoleInfo consoleInfo;
    private final XtsTypeLoader xtsTypeLoader;
    private final Supplier<String> xtsTypeSupplier = Suppliers.memoize(this::calculateXtsType);

    @Inject
    CommandHelper(ConsoleInfo consoleInfo, XtsTypeLoader xtsTypeLoader) {
        this.consoleInfo = consoleInfo;
        this.xtsTypeLoader = xtsTypeLoader;
    }

    public String getXtsType() {
        return this.xtsTypeSupplier.get();
    }

    private String calculateXtsType() {
        Optional<String> xtsTypeFromSystemProperty = this.consoleInfo.getXtsTypeFromSystemProperty();
        if (xtsTypeFromSystemProperty.isPresent()) {
            return xtsTypeFromSystemProperty.get();
        }
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        Supplier<String> multiDirHelpMessage = () -> String.format("Please specify XTS type by -D%s.", "XTS_TYPE");
        return this.xtsTypeLoader.getXtsType(xtsRootDir.toString(), multiDirHelpMessage);
    }
}

