/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.result.report;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.devtools.mobileharness.api.model.error.ExtErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.result.proto.ReportProto;
import com.google.devtools.mobileharness.infra.ats.console.result.report.Context;
import com.google.devtools.mobileharness.platform.android.xts.common.TestStatus;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CompatibilityReportParser {
    private final LocalFileUtil localFileUtil;
    private final XMLInputFactory xmlInputFactory;

    @Inject
    CompatibilityReportParser(XMLInputFactory xmlInputFactory) {
        this(xmlInputFactory, new LocalFileUtil());
    }

    @VisibleForTesting
    CompatibilityReportParser(XMLInputFactory xmlInputFactory, LocalFileUtil localFileUtil) {
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        this.xmlInputFactory = xmlInputFactory;
        this.localFileUtil = localFileUtil;
    }

    public Optional<ReportProto.Result> parse(Path reportXmlFile, boolean shallow) throws MobileHarnessException {
        if (!this.localFileUtil.isFileExist(reportXmlFile)) {
            return Optional.empty();
        }
        ReportProto.Result.Builder resultBuilder = ReportProto.Result.newBuilder();
        try (BufferedInputStream reportInputStream = new BufferedInputStream(new FileInputStream(reportXmlFile.toFile()));){
            Context context = new Context(resultBuilder);
            XMLEventReader xmlEventReader = this.xmlInputFactory.createXMLEventReader(reportInputStream, StandardCharsets.UTF_8.toString());
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        CompatibilityReportParser.enteringTag(event.asStartElement(), context);
                        break;
                    }
                    case 2: {
                        CompatibilityReportParser.exitingTag(event.asEndElement(), context);
                        break;
                    }
                    case 4: {
                        CompatibilityReportParser.characters(event.asCharacters(), context);
                        break;
                    }
                }
                if (!shallow || !CompatibilityReportParser.isSummaryEvent(event)) continue;
                break;
            }
        }
        catch (IOException ioe) {
            throw new MobileHarnessException(ExtErrorId.REPORT_PARSER_READ_XML_FILE_ERROR, "", ioe);
        }
        catch (XMLStreamException streamEx) {
            throw new MobileHarnessException(ExtErrorId.REPORT_PARSER_XML_EVENT_READER_ERROR, "", streamEx);
        }
        return Optional.of(resultBuilder.build());
    }

    private static boolean isSummaryEvent(XMLEvent event) {
        if (event.getEventType() != 1) {
            return false;
        }
        return event.asStartElement().getName().getLocalPart().equals("Summary");
    }

    private static void enteringTag(StartElement element, Context context) {
        String elementName;
        context.tagStack.push(element);
        switch (elementName = element.getName().getLocalPart()) {
            case "Result": {
                CompatibilityReportParser.handleResult(element, context);
                break;
            }
            case "Build": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Result")) break;
                CompatibilityReportParser.handleBuildInfo(element, context);
                break;
            }
            case "RunHistory": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Result")) break;
                CompatibilityReportParser.handleRunHistory(context);
                break;
            }
            case "Run": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "RunHistory")) break;
                CompatibilityReportParser.handleRunInRunHistory(element, context);
                break;
            }
            case "Summary": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Result")) break;
                CompatibilityReportParser.handleSummary(element, context);
                break;
            }
            case "Module": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Result")) break;
                CompatibilityReportParser.handleModule(element, context);
                break;
            }
            case "Reason": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Module")) break;
                CompatibilityReportParser.handleModuleReason(element, context);
                break;
            }
            case "TestCase": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Module")) break;
                CompatibilityReportParser.handleTestCase(element, context);
                break;
            }
            case "Test": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "TestCase")) break;
                CompatibilityReportParser.handleTest(element, context);
                break;
            }
            case "Failure": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Test")) break;
                CompatibilityReportParser.handleTestFailure(element, context);
                break;
            }
            case "StackTrace": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Failure")) break;
                CompatibilityReportParser.handleTestFailureStackTrace(context);
                break;
            }
            case "BugReport": 
            case "Logcat": 
            case "Screenshot": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Test")) break;
                CompatibilityReportParser.handleLoggedFile(element, context);
                break;
            }
            case "Metric": {
                if (!CompatibilityReportParser.parentIs(context.tagStack, "Test")) break;
                CompatibilityReportParser.handleMetric(element, context);
                break;
            }
        }
    }

    private static void exitingTag(EndElement element, Context context) {
        String elementName;
        context.tagStack.pop();
        switch (elementName = element.getName().getLocalPart()) {
            case "RunHistory": {
                CompatibilityReportParser.handleEndRunHistory(context);
                break;
            }
            case "Module": {
                CompatibilityReportParser.handleEndModule(context);
                break;
            }
            case "TestCase": {
                CompatibilityReportParser.handleEndTestCase(context);
                break;
            }
            case "Test": {
                CompatibilityReportParser.handleEndTest(context);
                break;
            }
            case "Failure": {
                CompatibilityReportParser.handleEndTestFailure(context);
                break;
            }
            case "StackTrace": {
                CompatibilityReportParser.handleEndTestFailureStackTrace(context);
                break;
            }
            case "BugReport": 
            case "Logcat": 
            case "Screenshot": {
                CompatibilityReportParser.handleEndLoggedFile(elementName, context);
                break;
            }
            case "Metric": {
                CompatibilityReportParser.handleEndMetric(context);
                break;
            }
        }
    }

    private static void characters(Characters element, Context context) {
        String tagName;
        if (element.isWhiteSpace()) {
            return;
        }
        StartElement tag = context.tagStack.peek();
        switch (tagName = tag.getName().getLocalPart()) {
            case "StackTrace": 
            case "BugReport": 
            case "Logcat": 
            case "Screenshot": 
            case "Metric": {
                CompatibilityReportParser.handleElementTextContent(tagName, element, context);
                break;
            }
        }
    }

    private static void handleResult(StartElement result, Context context) {
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(result);
        ImmutableList.Builder attributes = ImmutableList.builder();
        if (attributeMap.containsKey("start")) {
            attributes.add(ReportProto.Attribute.newBuilder().setKey("start").setValue(attributeMap.get("start").trim()).build());
            attributeMap.remove("start");
        }
        if (attributeMap.containsKey("end")) {
            attributes.add(ReportProto.Attribute.newBuilder().setKey("end").setValue(attributeMap.get("end").trim()).build());
            attributeMap.remove("end");
        }
        if (attributeMap.containsKey("start_display")) {
            attributes.add(ReportProto.Attribute.newBuilder().setKey("start_display").setValue(attributeMap.get("start_display").trim()).build());
            attributeMap.remove("start_display");
        }
        if (attributeMap.containsKey("end_display")) {
            attributes.add(ReportProto.Attribute.newBuilder().setKey("end_display").setValue(attributeMap.get("end_display").trim()).build());
            attributeMap.remove("end_display");
        }
        attributeMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(attr -> ReportProto.Attribute.newBuilder().setKey((String)attr.getKey()).setValue(((String)attr.getValue()).trim()).build()).forEach(attributes::add);
        context.resultBuilder.addAllAttribute(attributes.build());
        boolean isRetryResult = Boolean.parseBoolean(attributeMap.getOrDefault("is_retry_result", "false"));
        if (isRetryResult) {
            context.resultBuilder.setIsRetryResult(true);
        }
    }

    private static void handleBuildInfo(StartElement buildInfo, Context context) {
        ReportProto.BuildInfo.Builder build = ReportProto.BuildInfo.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(buildInfo);
        if (attributeMap.containsKey("build_fingerprint")) {
            build.setBuildFingerprint(attributeMap.get("build_fingerprint").trim());
        }
        if (attributeMap.containsKey("build_fingerprint_unaltered")) {
            build.setBuildFingerprintUnaltered(attributeMap.get("build_fingerprint_unaltered").trim());
        }
        if (attributeMap.containsKey("build_vendor_fingerprint")) {
            build.setBuildVendorFingerprint(attributeMap.get("build_vendor_fingerprint").trim());
        }
        ImmutableList buildAttributes = attributeMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("build_")).sorted(Map.Entry.comparingByKey()).map(attr -> ReportProto.Attribute.newBuilder().setKey((String)attr.getKey()).setValue((String)attr.getValue()).build()).collect(ImmutableList.toImmutableList());
        ImmutableList nonBuildAttributes = attributeMap.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("build_")).sorted(Map.Entry.comparingByKey()).map(attr -> ReportProto.Attribute.newBuilder().setKey((String)attr.getKey()).setValue((String)attr.getValue()).build()).collect(ImmutableList.toImmutableList());
        build.addAllAttribute(nonBuildAttributes).addAllAttribute(buildAttributes);
        context.resultBuilder.setBuild(build.build());
    }

    private static void handleRunHistory(Context context) {
        context.currentRunHistory = ReportProto.RunHistory.newBuilder();
    }

    private static void handleRunInRunHistory(StartElement run, Context context) {
        ReportProto.Run.Builder runBuilder = ReportProto.Run.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(run);
        if (attributeMap.containsKey("start")) {
            runBuilder.setStartTimeMillis(Long.parseLong(attributeMap.get("start").trim()));
        }
        if (attributeMap.containsKey("end")) {
            runBuilder.setEndTimeMillis(Long.parseLong(attributeMap.get("end").trim()));
        }
        if (attributeMap.containsKey("pass")) {
            runBuilder.setPassedTests(Long.parseLong(attributeMap.get("pass").trim()));
        }
        if (attributeMap.containsKey("failed")) {
            runBuilder.setFailedTests(Long.parseLong(attributeMap.get("failed").trim()));
        }
        if (attributeMap.containsKey("warning")) {
            runBuilder.setWarningTests(Long.parseLong(attributeMap.get("warning").trim()));
        }
        if (attributeMap.containsKey("command_line_args")) {
            runBuilder.setCommandLineArgs(attributeMap.get("command_line_args").trim());
        }
        if (attributeMap.containsKey("host_name")) {
            runBuilder.setHostName(attributeMap.get("host_name").trim());
        }
        context.currentRunHistory.addRun(runBuilder.build());
    }

    private static void handleSummary(StartElement summary, Context context) {
        ReportProto.Summary.Builder summaryBuilder = ReportProto.Summary.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(summary);
        if (attributeMap.containsKey("pass")) {
            summaryBuilder.setPassed(Integer.parseInt(attributeMap.get("pass").trim()));
        }
        if (attributeMap.containsKey("failed")) {
            summaryBuilder.setFailed(Integer.parseInt(attributeMap.get("failed").trim()));
        }
        if (attributeMap.containsKey("warning")) {
            summaryBuilder.setWarning(Integer.parseInt(attributeMap.get("warning").trim()));
        }
        if (attributeMap.containsKey("modules_done")) {
            summaryBuilder.setModulesDone(Integer.parseInt(attributeMap.get("modules_done").trim()));
        }
        if (attributeMap.containsKey("modules_total")) {
            summaryBuilder.setModulesTotal(Integer.parseInt(attributeMap.get("modules_total").trim()));
        }
        context.resultBuilder.setSummary(summaryBuilder.build());
    }

    private static void handleModule(StartElement module, Context context) {
        context.currentModule = ReportProto.Module.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(module);
        if (attributeMap.containsKey("name")) {
            context.currentModule.setName(attributeMap.get("name").trim());
        }
        if (attributeMap.containsKey("abi")) {
            context.currentModule.setAbi(attributeMap.get("abi").trim());
        }
        if (attributeMap.containsKey("runtime")) {
            context.currentModule.setRuntimeMillis(Long.parseLong(attributeMap.get("runtime")));
        }
        if (attributeMap.containsKey("done")) {
            context.currentModule.setDone(Boolean.parseBoolean(attributeMap.get("done").trim()));
        }
        if (attributeMap.containsKey("pass")) {
            context.currentModule.setPassed(Integer.parseInt(attributeMap.get("pass").trim()));
        }
        if (attributeMap.containsKey("total_tests")) {
            context.currentModule.setTotalTests(Integer.parseInt(attributeMap.get("total_tests").trim()));
        }
    }

    private static void handleModuleReason(StartElement moduleReason, Context context) {
        ReportProto.Reason.Builder reason = ReportProto.Reason.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(moduleReason);
        if (attributeMap.containsKey("message")) {
            reason.setMsg(attributeMap.get("message").trim());
        }
        if (attributeMap.containsKey("error_name")) {
            reason.setErrorName(attributeMap.get("error_name").trim());
        }
        if (attributeMap.containsKey("error_code")) {
            reason.setErrorCode(attributeMap.get("error_code").trim());
        }
        context.currentModule.setReason(reason.build());
    }

    private static void handleTestCase(StartElement testCase, Context context) {
        context.currentTestCase = ReportProto.TestCase.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(testCase);
        if (attributeMap.containsKey("name")) {
            context.currentTestCase.setName(attributeMap.get("name").trim());
        }
    }

    private static void handleTest(StartElement test, Context context) {
        context.currentTest = ReportProto.Test.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(test);
        if (attributeMap.containsKey("result")) {
            context.currentTest.setResult(attributeMap.get("result").trim());
        }
        if (attributeMap.containsKey("name")) {
            context.currentTest.setName(attributeMap.get("name").trim());
        }
        if (attributeMap.containsKey("skipped")) {
            context.currentTest.setSkipped(Boolean.parseBoolean(attributeMap.get("skipped").trim()));
        }
    }

    private static void handleTestFailure(StartElement testFailure, Context context) {
        context.currentTestFailure = ReportProto.TestFailure.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(testFailure);
        if (attributeMap.containsKey("message")) {
            context.currentTestFailure.setMsg(attributeMap.get("message").trim());
        }
        if (attributeMap.containsKey("error_name")) {
            context.currentTestFailure.setErrorName(attributeMap.get("error_name").trim());
        }
        if (attributeMap.containsKey("error_code")) {
            context.currentTestFailure.setErrorCode(attributeMap.get("error_code").trim());
        }
    }

    private static void handleTestFailureStackTrace(Context context) {
        context.currentStackTrace = ReportProto.StackTrace.newBuilder();
    }

    private static void handleLoggedFile(StartElement loggedFile, Context context) {
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(loggedFile);
        String elementName = loggedFile.getName().getLocalPart();
        if (attributeMap.containsKey("file_name")) {
            switch (elementName) {
                case "BugReport": {
                    context.currentBugReport = ReportProto.LoggedFile.newBuilder();
                    context.currentBugReport.setFileName(attributeMap.get("file_name").trim());
                    break;
                }
                case "Logcat": {
                    context.currentLogcat = ReportProto.LoggedFile.newBuilder();
                    context.currentLogcat.setFileName(attributeMap.get("file_name").trim());
                    break;
                }
                case "Screenshot": {
                    context.currentScreenshot = ReportProto.LoggedFile.newBuilder();
                    context.currentScreenshot.setFileName(attributeMap.get("file_name").trim());
                    break;
                }
            }
        }
    }

    private static void handleMetric(StartElement metric, Context context) {
        context.currentMetric = ReportProto.Metric.newBuilder();
        Map<String, String> attributeMap = CompatibilityReportParser.getAttributeMap(metric);
        if (attributeMap.containsKey("key")) {
            context.currentMetric.setKey(attributeMap.get("key").trim());
        }
    }

    private static void handleEndRunHistory(Context context) {
        if (context.currentRunHistory != null) {
            context.resultBuilder.setRunHistory(context.currentRunHistory.build());
            context.currentRunHistory = null;
        }
    }

    private static void handleEndModule(Context context) {
        if (context.currentModule != null) {
            ReportProto.Module.Builder currentModuleBuilder = context.currentModule;
            int failedTests = 0;
            int warningTests = 0;
            for (ReportProto.TestCase testCase : currentModuleBuilder.getTestCaseList()) {
                for (ReportProto.Test test : testCase.getTestList()) {
                    if (test.getResult().equals(TestStatus.convertToTestStatusCompatibilityString(TestStatus.FAILURE))) {
                        ++failedTests;
                        continue;
                    }
                    if (!test.getResult().equals(TestStatus.convertToTestStatusCompatibilityString(TestStatus.WARNING))) continue;
                    ++warningTests;
                }
            }
            currentModuleBuilder.setFailedTests(failedTests);
            currentModuleBuilder.setWarningTests(warningTests);
            context.resultBuilder.addModuleInfo(context.currentModule.build());
            context.currentModule = null;
        }
    }

    private static void handleEndTestCase(Context context) {
        if (context.currentTestCase != null) {
            context.currentModule.addTestCase(context.currentTestCase.build());
            context.currentTestCase = null;
        }
    }

    private static void handleEndTest(Context context) {
        if (context.currentTest != null) {
            context.currentTestCase.addTest(context.currentTest.build());
            context.currentTest = null;
        }
    }

    private static void handleEndTestFailure(Context context) {
        if (context.currentTestFailure != null) {
            context.currentTest.setFailure(context.currentTestFailure.build());
            context.currentTestFailure = null;
        }
    }

    private static void handleEndTestFailureStackTrace(Context context) {
        if (context.currentStackTrace != null) {
            context.currentTestFailure.setStackTrace(context.currentStackTrace.build());
            context.currentStackTrace = null;
        }
    }

    private static void handleEndLoggedFile(String elementName, Context context) {
        switch (elementName) {
            case "BugReport": {
                if (context.currentBugReport == null) break;
                context.currentTest.setBugReport(context.currentBugReport.build());
                context.currentBugReport = null;
                break;
            }
            case "Logcat": {
                if (context.currentLogcat == null) break;
                context.currentTest.setLogcat(context.currentLogcat.build());
                context.currentLogcat = null;
                break;
            }
            case "Screenshot": {
                if (context.currentScreenshot == null) break;
                context.currentTest.addScreenshot(context.currentScreenshot.build());
                context.currentScreenshot = null;
                break;
            }
        }
    }

    private static void handleEndMetric(Context context) {
        if (context.currentMetric != null) {
            context.currentTest.addMetric(context.currentMetric.build());
            context.currentMetric = null;
        }
    }

    private static void handleElementTextContent(String elementName, Characters content, Context context) {
        if (content.isWhiteSpace()) {
            return;
        }
        String textContent = content.getData().trim();
        switch (elementName) {
            case "StackTrace": {
                context.currentStackTrace.setContent(textContent);
                break;
            }
            case "BugReport": {
                context.currentBugReport.setContent(textContent);
                break;
            }
            case "Logcat": {
                context.currentLogcat.setContent(textContent);
                break;
            }
            case "Screenshot": {
                context.currentScreenshot.setContent(textContent);
                break;
            }
            case "Metric": {
                context.currentMetric.setContent(textContent);
                break;
            }
        }
    }

    private static Map<String, String> getAttributeMap(StartElement element) {
        Iterator<Attribute> attributesIt = element.getAttributes();
        LinkedHashMap<String, String> attributeMap = Maps.newLinkedHashMap();
        while (attributesIt.hasNext()) {
            Attribute attribute = attributesIt.next();
            attributeMap.put(attribute.getName().toString(), attribute.getValue());
        }
        return attributeMap;
    }

    private static boolean parentIs(Deque<StartElement> stack, @Nullable String parentElementName) {
        if (parentElementName == null) {
            return stack.isEmpty();
        }
        StartElement current = stack.poll();
        StartElement parent = stack.peek();
        boolean parentMatch = parent != null && parentElementName.equals(parent.getName().getLocalPart());
        stack.push(current);
        return parentMatch;
    }
}

