/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.controller.olcserver;

import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.Annotations;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.console.util.log.LogRecordPrinter;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.ControlServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.LogProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.ControlStub;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ServerLogPrinter {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final ImmutableSet<Status.Code> NORMAL_CODES = ImmutableSet.of(Status.Code.UNAVAILABLE, Status.Code.CANCELLED);
    private final LogRecordPrinter logRecordPrinter;
    private final Provider<ControlStub> controlStubProvider;
    private final ServerPreparer serverPreparer;
    private final String clientId;
    private final GetLogResponseObserver responseObserver = new GetLogResponseObserver();
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean enable;
    @GuardedBy(value="lock")
    private StreamObserver<ControlServiceProto.GetLogRequest> requestObserver;

    @Inject
    ServerLogPrinter(LogRecordPrinter logRecordPrinter, @Annotations.ServerStub(value=Annotations.ServerStub.Type.CONTROL_SERVICE) Provider<ControlStub> controlStubProvider, ServerPreparer serverPreparer, @Annotations.ClientId String clientId) {
        this.logRecordPrinter = logRecordPrinter;
        this.controlStubProvider = controlStubProvider;
        this.serverPreparer = serverPreparer;
        this.clientId = clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() throws MobileHarnessException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.enable(!this.enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(boolean enable) throws MobileHarnessException, InterruptedException {
        if (Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.enable = enable;
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("%s server log.", enable ? "Printing" : "Stop printing");
            if (enable) {
                this.serverPreparer.prepareOlcServer();
                if (this.requestObserver == null) {
                    this.requestObserver = Objects.requireNonNull(this.controlStubProvider.get()).getLog(this.responseObserver);
                }
                this.requestObserver.onNext(ControlServiceProto.GetLogRequest.newBuilder().setEnable(true).setClientId(this.clientId).build());
            } else if (this.requestObserver != null) {
                this.requestObserver.onCompleted();
                this.requestObserver = null;
            }
        }
    }

    private class GetLogResponseObserver
    implements StreamObserver<ControlServiceProto.GetLogResponse> {
        private GetLogResponseObserver() {
        }

        @Override
        public void onNext(ControlServiceProto.GetLogResponse response) {
            for (LogProto.LogRecord logRecord : response.getLogRecords().getLogRecordList()) {
                ServerLogPrinter.this.logRecordPrinter.printLogRecord(logRecord);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (e instanceof StatusRuntimeException && NORMAL_CODES.contains((Object)((StatusRuntimeException)e).getStatus().getCode())) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Stop getting from server since it stops");
            } else {
                ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to get log from server");
            }
            this.doOnCompleted();
        }

        @Override
        public void onCompleted() {
            this.doOnCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doOnCompleted() {
            Object object = ServerLogPrinter.this.lock;
            synchronized (object) {
                ServerLogPrinter.this.requestObserver = null;
            }
        }
    }
}

