/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.FlagsString;
import com.google.devtools.mobileharness.infra.ats.common.SessionRequestInfo;
import com.google.devtools.mobileharness.infra.ats.console.AtsConsoleModule;
import com.google.devtools.mobileharness.infra.ats.console.GuiceFactory;
import com.google.devtools.mobileharness.infra.ats.console.command.RunCommand;
import com.google.devtools.mobileharness.shared.util.inject.CommonModule;
import com.google.devtools.mobileharness.shared.util.shell.ShellUtils;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import picocli.CommandLine;

public final class CommandLineParser {
    private static volatile CommandLineParser instance;
    private static final Object INSTANCE_LOCK;
    @GuardedBy(value="parseCommandLock")
    private final Injector injector;
    @GuardedBy(value="parseCommandLock")
    private final RunCommandParseResult runCommandParseResult;
    private final Object parseCommandLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandLineParser getInstance() {
        if (instance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new CommandLineParser();
                }
            }
        }
        return instance;
    }

    @VisibleForTesting
    CommandLineParser() {
        ImmutableMap<String, String> systemProperties = System.getProperties().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        this.runCommandParseResult = new RunCommandParseResult();
        this.injector = Guice.createInjector(new AtsConsoleModule("command-line-parser-" + String.valueOf(UUID.randomUUID()), FlagsString.of("", ImmutableList.of()), ImmutableList.of(), systemProperties, null, System.out, System.err, this.runCommandParseResult, true), new CommonModule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionRequestInfo.Builder parseCommandLine(String tfCommand) throws MobileHarnessException {
        Object object = this.parseCommandLock;
        synchronized (object) {
            SessionRequestInfo.Builder result;
            ImmutableList<String> tokens;
            try {
                tokens = ShellUtils.tokenize(tfCommand);
            }
            catch (ShellUtils.TokenizationException e) {
                throw new MobileHarnessException(InfraErrorId.ATS_SERVER_INVALID_REQUEST_ERROR, "Failed to tokenize the xTS command line: " + tfCommand, e);
            }
            CommandLine commandLine = new CommandLine(RunCommand.class, new GuiceFactory(this.injector)).setCaseInsensitiveEnumValuesAllowed(true).setUnmatchedOptionsArePositionalParams(true);
            commandLine.execute(tokens.toArray(new String[0]));
            ListenableFuture<SessionRequestInfo.Builder> resultFuture = this.runCommandParseResult.poll();
            if (resultFuture != null && resultFuture.isDone()) {
                try {
                    result = Futures.getDone(resultFuture);
                }
                catch (ExecutionException e) {
                    throw new MobileHarnessException(InfraErrorId.ATS_SERVER_INVALID_REQUEST_ERROR, "Failed to parse command line: " + tfCommand, e.getCause());
                }
            } else {
                throw new MobileHarnessException(InfraErrorId.ATS_SERVER_INVALID_REQUEST_ERROR, "The command line contains syntax error: " + tfCommand);
            }
            return result;
        }
    }

    static {
        INSTANCE_LOCK = new Object();
    }

    private static class RunCommandParseResult
    implements Consumer<ListenableFuture<SessionRequestInfo.Builder>> {
        private volatile ListenableFuture<SessionRequestInfo.Builder> resultFuture;

        private RunCommandParseResult() {
        }

        @Override
        public void accept(ListenableFuture<SessionRequestInfo.Builder> resultFuture) {
            this.resultFuture = resultFuture;
        }

        private ListenableFuture<SessionRequestInfo.Builder> poll() {
            ListenableFuture<SessionRequestInfo.Builder> resultFuture = this.resultFuture;
            this.resultFuture = null;
            return resultFuture;
        }
    }
}

