/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.AddSubPlanArgs;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.ResultType;
import com.google.devtools.mobileharness.platform.android.xts.suite.subplan.SubPlanCreator;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="add", sortOptions=false, description={"Create a subplan derived from previous session."}, synopsisSubcommandLabel="", subcommands={CommandLine.HelpCommand.class})
class AddCommand
implements Callable<Integer> {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private final ConsoleInfo consoleInfo;
    private final CommandHelper commandHelper;
    private final ConsoleUtil consoleUtil;
    private final SubPlanCreator subPlanCreator;

    @Inject
    AddCommand(ConsoleInfo consoleInfo, CommandHelper commandHelper, ConsoleUtil consoleUtil, SubPlanCreator subPlanCreator) {
        this.consoleInfo = consoleInfo;
        this.commandHelper = commandHelper;
        this.consoleUtil = consoleUtil;
        this.subPlanCreator = subPlanCreator;
    }

    @Override
    public Integer call() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand");
    }

    @CommandLine.Command(name="subplan", aliases={"s"}, description={"Create a subplan derived from previous session; this option generates a subplan that can be used to run a subset of tests."})
    public int subPlan(@CommandLine.Option(names={"--session"}, required=true, description={"The session used to create a subplan."}) int sessionIndex, @CommandLine.Option(names={"--name", "-n"}, required=false, description={"The name of the new subplan."}) String name, @CommandLine.Option(names={"--result-type"}, required=false, description={"Which results to include in the subplan. One of: ${COMPLETION-CANDIDATES}. Repeatable."}, split="\\s*,\\s*") List<ResultType> resultTypes, @CommandLine.Option(names={"--module", "-m"}, required=false, description={"The test module to run."}) String module, @CommandLine.Option(names={"--is-non-tradefed-module"}, required=false, description={"Whether the given module is for Non-Tradefed. False by default."}) boolean isNonTradefedModule, @CommandLine.Option(names={"--test", "-t"}, required=false, description={"The test to run, combined with the given module. Only works when module specified."}) String test, @CommandLine.Option(names={"--abi", "-a"}, required=false, description={"The abi to test, combined with the given module. Only works when module specified."}) String abi, @CommandLine.Option(names={"--exclude-filter"}, paramLabel="\"[abi] <module_name> <test_name>\"", description={"Exclude the specified modules, or test packages, classes, and cases, from the subplan. For example, add subplan --session <session_index> --exclude-filter \"CtsCalendarcommon2Test android.calendarcommon2.cts.Calendarcommon2Test#testStaticLinking\" excludes the specified test case."}) List<String> excludeFilters) throws MobileHarnessException {
        Optional<File> subPlanFile;
        Path xtsRootDirectory = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        String xtsType = this.commandHelper.getXtsType();
        AddSubPlanArgs.Builder addSubPlanArgsBuilder = AddSubPlanArgs.builder().setXtsRootDir(xtsRootDirectory).setXtsType(xtsType).setSessionIndex(sessionIndex);
        if (!Strings.isNullOrEmpty(name)) {
            addSubPlanArgsBuilder.setSubPlanName(name);
        }
        if (resultTypes != null) {
            addSubPlanArgsBuilder.setResultTypes(ImmutableSet.copyOf(resultTypes));
        }
        if (!Strings.isNullOrEmpty(module)) {
            addSubPlanArgsBuilder.setModule(module);
        }
        if (isNonTradefedModule) {
            addSubPlanArgsBuilder.setIsNonTradefedModule(true);
        }
        if (!Strings.isNullOrEmpty(test)) {
            addSubPlanArgsBuilder.setTest(test);
        }
        if (!Strings.isNullOrEmpty(abi)) {
            addSubPlanArgsBuilder.setAbi(abi);
        }
        if (excludeFilters != null) {
            addSubPlanArgsBuilder.setPassedInExcludeFilters(ImmutableSet.copyOf(excludeFilters));
        }
        if ((subPlanFile = this.subPlanCreator.createAndSerializeSubPlan(addSubPlanArgsBuilder.build())).isPresent()) {
            this.consoleUtil.printlnStdout("Created subplan file at: %s", subPlanFile.get());
        } else {
            this.consoleUtil.printlnStdout("Subplan file not created");
        }
        return 0;
    }
}

