/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.mobileharness.infra.ats.console.Annotations;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConsoleInfo {
    public static final String XTS_TYPE_PROPERTY_KEY = "XTS_TYPE";
    private static final String XTS_ROOT_DIR_PROPERTY_KEY = "XTS_ROOT";
    private static final String PYTHON_PACKAGE_INDEX_URL_PROPERTY_KEY = "PYTHON_PACKAGE_INDEX_URL";
    private final AtomicReference<String> pythonPackageIndexUrl = new AtomicReference();
    private final ImmutableMap<String, String> systemProperties;
    private volatile ImmutableList<String> lastCommand = ImmutableList.of();

    @Inject
    @VisibleForTesting
    public ConsoleInfo(@Annotations.SystemProperties ImmutableMap<String, String> systemProperties) {
        this.systemProperties = systemProperties;
        this.setPythonPackageIndexUrl(systemProperties.get(PYTHON_PACKAGE_INDEX_URL_PROPERTY_KEY));
    }

    public void setLastCommand(ImmutableList<String> lastCommand) {
        this.lastCommand = lastCommand;
    }

    public ImmutableList<String> getLastCommand() {
        return this.lastCommand;
    }

    public Path getXtsRootDirectoryNonEmpty() {
        String result = this.systemProperties.get(XTS_ROOT_DIR_PROPERTY_KEY);
        Preconditions.checkState(result != null, "XTS root dir is not specified by -D%s", (Object)XTS_ROOT_DIR_PROPERTY_KEY);
        return Path.of(result, new String[0]).normalize();
    }

    public Optional<String> getXtsTypeFromSystemProperty() {
        return Optional.ofNullable(this.systemProperties.get(XTS_TYPE_PROPERTY_KEY));
    }

    public void setPythonPackageIndexUrl(String pythonPackageIndexUrl) {
        this.pythonPackageIndexUrl.set(pythonPackageIndexUrl);
    }

    public Optional<String> getPythonPackageIndexUrl() {
        return Optional.ofNullable(this.pythonPackageIndexUrl.get());
    }
}

