/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.mobileharness.infra.ats.common.FlagsString;
import com.google.devtools.mobileharness.infra.ats.common.SessionRequestInfo;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.OlcServerConnectorModule;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerEnvironmentPreparer;
import com.google.devtools.mobileharness.infra.ats.console.Annotations;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.XtsServerEnvironmentPreparer;
import com.google.devtools.mobileharness.infra.ats.console.result.report.CompatibilityReportModule;
import com.google.devtools.mobileharness.infra.client.longrunningservice.OlcServerRunner;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.multibindings.OptionalBinder;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.jline.reader.LineReader;

public class AtsConsoleModule
extends AbstractModule {
    private final String consoleId;
    private final FlagsString deviceInfraServiceFlags;
    private final ImmutableList<String> mainArgs;
    private final ImmutableMap<String, String> systemProperties;
    @Nullable
    private final LineReader consoleLineReader;
    private final PrintStream consoleOutputOut;
    private final PrintStream consoleOutputErr;
    private final Consumer<ListenableFuture<SessionRequestInfo.Builder>> resultFuture;
    private final boolean parseCommandOnly;

    public AtsConsoleModule(String consoleId, FlagsString deviceInfraServiceFlags, List<String> mainArgs, Map<String, String> systemProperties, @Nullable LineReader consoleLineReader, PrintStream consoleOutputOut, PrintStream consoleOutputErr, Consumer<ListenableFuture<SessionRequestInfo.Builder>> resultFuture, boolean parseCommandOnly) {
        this.consoleId = consoleId;
        this.deviceInfraServiceFlags = deviceInfraServiceFlags;
        this.mainArgs = ImmutableList.copyOf(mainArgs);
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        this.consoleLineReader = consoleLineReader;
        this.consoleOutputOut = consoleOutputOut;
        this.consoleOutputErr = consoleOutputErr;
        this.resultFuture = resultFuture;
        this.parseCommandOnly = parseCommandOnly;
    }

    @Override
    protected void configure() {
        this.bind(ServerEnvironmentPreparer.class).to(XtsServerEnvironmentPreparer.class).in(Singleton.class);
        this.install(new OlcServerConnectorModule(this.deviceInfraServiceFlags, "ATS console", this.consoleId));
        this.install(new CompatibilityReportModule());
        OptionalBinder.newOptionalBinder(this.binder(), OlcServerRunner.class);
    }

    @Provides
    @Annotations.MainArgs
    ImmutableList<String> provideMainArgs() {
        return this.mainArgs;
    }

    @Provides
    @Annotations.RunCommandParsingResultFuture
    Consumer<ListenableFuture<SessionRequestInfo.Builder>> provideResultFuture() {
        return this.resultFuture;
    }

    @Provides
    @Annotations.ParseCommandOnly
    boolean provideParseCommandOnly() {
        return this.parseCommandOnly;
    }

    @Provides
    @Annotations.SystemProperties
    ImmutableMap<String, String> provideSystemProperties() {
        return this.systemProperties;
    }

    @Provides
    @Nullable
    @Annotations.ConsoleLineReader
    LineReader provideConsoleLineReader() {
        return this.consoleLineReader;
    }

    @Provides
    @Singleton
    @Annotations.ConsoleOutput(value=Annotations.ConsoleOutput.Type.OUT_WRITER)
    PrintWriter provideConsoleOutputOutWriter() {
        return new PrintWriter(this.consoleOutputOut, true, StandardCharsets.UTF_8);
    }

    @Provides
    @Singleton
    @Annotations.ConsoleOutput(value=Annotations.ConsoleOutput.Type.ERR_WRITER)
    PrintWriter provideConsoleOutputErrWriter() {
        return new PrintWriter(this.consoleOutputErr, true, StandardCharsets.UTF_8);
    }
}

