/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common.olcserver;

import com.google.devtools.mobileharness.infra.ats.common.FlagsString;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.Annotations;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.OlcServerGrpcChannelModule;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.ControlStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.SessionStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.VersionStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.grpc.ControlGrpcStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.grpc.SessionGrpcStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.grpc.VersionGrpcStub;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import io.grpc.Channel;
import javax.inject.Singleton;

public class OlcServerConnectorModule
extends AbstractModule {
    private final FlagsString deviceInfraServiceFlags;
    private final String clientComponentName;
    private final String clientId;

    public OlcServerConnectorModule(FlagsString deviceInfraServiceFlags, String clientComponentName, String clientId) {
        this.deviceInfraServiceFlags = deviceInfraServiceFlags;
        this.clientComponentName = clientComponentName;
        this.clientId = clientId;
    }

    @Override
    protected void configure() {
        if (!Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            this.install(new OlcServerGrpcChannelModule());
        }
    }

    @Provides
    @Annotations.ClientComponentName
    String provideClientComponentName() {
        return this.clientComponentName;
    }

    @Provides
    @Annotations.ClientId
    String provideClientId() {
        return this.clientId;
    }

    @Provides
    @Annotations.DeviceInfraServiceFlags
    FlagsString provideDeviceInfraServiceFlags() {
        return this.deviceInfraServiceFlags;
    }

    @Provides
    @Singleton
    @Annotations.ServerStub(value=Annotations.ServerStub.Type.CONTROL_SERVICE)
    ControlStub provideServerControlStub(@Annotations.ServerChannel Channel serverChannel) {
        return new ControlGrpcStub(serverChannel);
    }

    @Provides
    @Singleton
    @Annotations.ServerStub(value=Annotations.ServerStub.Type.SESSION_SERVICE)
    SessionStub provideServerSessionStub(@Annotations.ServerChannel Channel serverChannel) {
        return new SessionGrpcStub(serverChannel);
    }

    @Provides
    @Singleton
    @Annotations.ServerStub(value=Annotations.ServerStub.Type.VERSION_SERVICE)
    VersionStub provideServerVersionStub(@Annotations.ServerChannel Channel serverChannel) {
        return new VersionGrpcStub(serverChannel);
    }
}

