/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.mobileharness.infra.ats.common.AutoValue_SessionRequestInfo;
import com.google.devtools.mobileharness.infra.ats.common.proto.XtsCommonProto;
import com.google.devtools.mobileharness.infra.ats.server.proto.ServiceProto;
import com.google.devtools.mobileharness.platform.android.xts.config.proto.ConfigurationProto;
import com.google.devtools.mobileharness.platform.android.xts.suite.retry.RetryType;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class SessionRequestInfo {
    public abstract String testPlan();

    public abstract String commandLineArgs();

    public abstract String xtsRootDir();

    public abstract Optional<String> androidXtsZip();

    public abstract ImmutableList<String> deviceSerials();

    public abstract ImmutableList<String> excludeDeviceSerials();

    public abstract ImmutableList<String> productTypes();

    public abstract ImmutableMap<String, String> deviceProperties();

    public abstract ImmutableList<String> moduleNames();

    public abstract Optional<String> testName();

    public abstract Optional<Integer> shardCount();

    public abstract ImmutableList<String> includeFilters();

    public abstract ImmutableList<String> excludeFilters();

    public abstract ImmutableMultimap<String, String> moduleMetadataIncludeFilters();

    public abstract ImmutableMultimap<String, String> moduleMetadataExcludeFilters();

    public abstract Optional<Integer> retrySessionIndex();

    public abstract Optional<String> retrySessionResultDirName();

    public abstract Optional<String> retrySessionId();

    public abstract Optional<RetryType> retryType();

    public abstract Optional<String> retryResultDir();

    public abstract ImmutableList<String> moduleArgs();

    public abstract ImmutableList<String> extraArgs();

    public abstract String xtsType();

    public abstract Optional<String> pythonPkgIndexUrl();

    public abstract ImmutableSet<String> givenMatchedNonTfModules();

    public abstract ImmutableMap<String, ConfigurationProto.Configuration> v2ConfigsMap();

    public abstract ImmutableMap<String, ConfigurationProto.Configuration> expandedModules();

    public abstract boolean enableModuleParameter();

    public abstract boolean enableModuleOptionalParameter();

    public abstract Duration jobTimeout();

    public abstract Duration startTimeout();

    public abstract ImmutableMap<String, String> envVars();

    public abstract Optional<String> subPlanName();

    public abstract Optional<String> subPlanNameBackup();

    public abstract boolean htmlInZip();

    public abstract Optional<String> sessionClientId();

    public abstract Optional<String> deviceType();

    public abstract Optional<Integer> maxBatteryLevel();

    public abstract Optional<Integer> minBatteryLevel();

    public abstract Optional<Integer> maxBatteryTemperature();

    public abstract Optional<Integer> minSdkLevel();

    public abstract Optional<Integer> maxSdkLevel();

    public abstract boolean isAtsServerRequest();

    public abstract Optional<String> remoteRunnerFilePathPrefix();

    public abstract boolean reportSystemCheckers();

    public abstract XtsCommonProto.ShardingMode shardingMode();

    public abstract Optional<Boolean> skipDeviceInfo();

    public abstract Optional<Boolean> isXtsDynamicDownloadEnabled();

    public abstract ImmutableMap<String, String> xtsSuiteInfo();

    public abstract ImmutableSet<String> excludeRunners();

    public abstract ImmutableList<ServiceProto.TestResource> atsServerTestResources();

    public abstract Optional<ServiceProto.TestEnvironment> atsServerTestEnvironment();

    public static Builder builder() {
        return new AutoValue_SessionRequestInfo.Builder().setModuleNames(ImmutableList.of()).setDeviceSerials(ImmutableList.of()).setExcludeDeviceSerials(ImmutableList.of()).setProductTypes(ImmutableList.of()).setDeviceProperties(ImmutableMap.of()).setIncludeFilters(ImmutableList.of()).setExcludeFilters(ImmutableList.of()).setModuleMetadataIncludeFilters(ImmutableMultimap.of()).setModuleMetadataExcludeFilters(ImmutableMultimap.of()).setModuleArgs(ImmutableList.of()).setExtraArgs(ImmutableList.of()).setGivenMatchedNonTfModules(ImmutableSet.of()).setV2ConfigsMap(ImmutableMap.of()).setExpandedModules(ImmutableMap.of()).setEnableModuleParameter(false).setEnvVars(ImmutableMap.of()).setEnableModuleOptionalParameter(false).setJobTimeout(Duration.ZERO).setStartTimeout(Duration.ZERO).setHtmlInZip(false).setReportSystemCheckers(false).setIsAtsServerRequest(false).setShardingMode(XtsCommonProto.ShardingMode.RUNNER).setXtsSuiteInfo(ImmutableMap.of()).setAtsServerTestResources(ImmutableList.of()).setExcludeRunners(ImmutableSet.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTestPlan(String var1);

        public abstract Builder setCommandLineArgs(String var1);

        public abstract Builder setXtsRootDir(String var1);

        public abstract Builder setDeviceSerials(List<String> var1);

        public abstract Builder setExcludeDeviceSerials(List<String> var1);

        public abstract Builder setProductTypes(List<String> var1);

        public abstract Builder setDeviceProperties(ImmutableMap<String, String> var1);

        public abstract Builder setModuleNames(List<String> var1);

        public abstract Builder setTestName(String var1);

        public abstract Builder setShardCount(int var1);

        public abstract Builder setIncludeFilters(List<String> var1);

        public abstract Builder setExcludeFilters(List<String> var1);

        public abstract Builder setModuleMetadataIncludeFilters(ImmutableMultimap<String, String> var1);

        public abstract Builder setModuleMetadataExcludeFilters(ImmutableMultimap<String, String> var1);

        public abstract Builder setRetrySessionIndex(Integer var1);

        public abstract Builder setRetrySessionResultDirName(String var1);

        public abstract Builder setRetrySessionId(String var1);

        public abstract Builder setRetryType(RetryType var1);

        public abstract Builder setRetryResultDir(String var1);

        public abstract Builder setModuleArgs(List<String> var1);

        public abstract Builder setExtraArgs(List<String> var1);

        public abstract Builder setXtsType(String var1);

        public abstract Builder setPythonPkgIndexUrl(String var1);

        public abstract Builder setAndroidXtsZip(String var1);

        public abstract Builder setEnvVars(ImmutableMap<String, String> var1);

        public abstract Builder setGivenMatchedNonTfModules(ImmutableSet<String> var1);

        public abstract Builder setV2ConfigsMap(ImmutableMap<String, ConfigurationProto.Configuration> var1);

        public abstract Builder setExpandedModules(ImmutableMap<String, ConfigurationProto.Configuration> var1);

        public abstract Builder setEnableModuleParameter(boolean var1);

        public abstract Builder setEnableModuleOptionalParameter(boolean var1);

        public abstract Builder setJobTimeout(Duration var1);

        public abstract Builder setStartTimeout(Duration var1);

        public abstract Builder setSubPlanName(String var1);

        public abstract Builder setSubPlanNameBackup(String var1);

        public abstract Builder setHtmlInZip(boolean var1);

        public abstract Builder setSessionClientId(String var1);

        public abstract Builder setDeviceType(String var1);

        public abstract Builder setMaxBatteryLevel(int var1);

        public abstract Builder setMinBatteryLevel(int var1);

        public abstract Builder setMaxBatteryTemperature(int var1);

        public abstract Builder setMinSdkLevel(int var1);

        public abstract Builder setMaxSdkLevel(int var1);

        public abstract Builder setIsAtsServerRequest(boolean var1);

        public abstract Builder setRemoteRunnerFilePathPrefix(String var1);

        public abstract Builder setReportSystemCheckers(boolean var1);

        public abstract Builder setShardingMode(XtsCommonProto.ShardingMode var1);

        public abstract Builder setSkipDeviceInfo(boolean var1);

        public abstract Builder setIsXtsDynamicDownloadEnabled(boolean var1);

        public abstract Builder setXtsSuiteInfo(ImmutableMap<String, String> var1);

        public abstract Builder setExcludeRunners(ImmutableSet<String> var1);

        public abstract Builder setAtsServerTestResources(ImmutableList<ServiceProto.TestResource> var1);

        public abstract Builder setAtsServerTestEnvironment(ServiceProto.TestEnvironment var1);

        protected abstract SessionRequestInfo autoBuild();

        public SessionRequestInfo build() {
            SessionRequestInfo sessionRequestInfo = this.autoBuild();
            if (sessionRequestInfo.testPlan().equals("retry")) {
                Preconditions.checkState(sessionRequestInfo.retrySessionIndex().isPresent() || sessionRequestInfo.retrySessionResultDirName().isPresent() || sessionRequestInfo.retrySessionId().isPresent());
                if (sessionRequestInfo.retrySessionId().isPresent()) {
                    Preconditions.checkState(sessionRequestInfo.retryResultDir().isPresent());
                }
            }
            return sessionRequestInfo;
        }
    }
}

