/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.infra.ats.common.FlagsString;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import com.google.devtools.mobileharness.shared.util.shell.ShellUtils;
import java.util.List;

public class DeviceInfraServiceUtil {
    private static final String DEVICE_INFRA_SERVICE_FLAGS_PROPERTY_KEY = "DEVICE_INFRA_SERVICE_FLAGS";

    public static FlagsString getDeviceInfraServiceFlagsFromSystemProperty() {
        String property = System.getProperties().getProperty(DEVICE_INFRA_SERVICE_FLAGS_PROPERTY_KEY);
        if (Strings.isNullOrEmpty(property)) {
            return FlagsString.of("", ImmutableList.of());
        }
        try {
            return FlagsString.of(property, ShellUtils.tokenize(property));
        }
        catch (ShellUtils.TokenizationException e) {
            throw new IllegalArgumentException(String.format("Invalid device infra flags property value, key=[%s], value=[%s]", DEVICE_INFRA_SERVICE_FLAGS_PROPERTY_KEY, property), e);
        }
    }

    public static void parseFlags(List<String> flags) {
        String[] flagArray = flags.toArray(new String[0]);
        Flags.parse(flagArray);
    }

    private DeviceInfraServiceUtil() {
    }
}

