/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.api.model.error;

import com.google.common.base.Preconditions;
import com.google.devtools.common.metrics.stability.model.proto.ErrorTypeProto;
import com.google.devtools.common.metrics.stability.util.ErrorIdFormatter;
import com.google.devtools.mobileharness.api.model.error.ErrorId;

public enum UserErrorId implements ErrorId
{
    UNABLE_TO_EXTRACT_TEST_NAME_FROM_FILE_NAME(201001, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    USER_ERROR_ID_PLACE_HOLDER_TO_BE_RENAMED(600000, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE);

    public static final int MIN_CODE = 200001;
    public static final int MAX_CODE = 600000;
    private final int code;
    private final ErrorTypeProto.ErrorType type;

    private UserErrorId(int code, ErrorTypeProto.ErrorType type) {
        Preconditions.checkArgument(code >= 200001);
        Preconditions.checkArgument(code <= 600000);
        Preconditions.checkArgument(type == ErrorTypeProto.ErrorType.CUSTOMER_ISSUE);
        this.code = code;
        this.type = type;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public ErrorTypeProto.ErrorType type() {
        return this.type;
    }

    public String toString() {
        return ErrorIdFormatter.formatErrorId(this);
    }
}

