/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.api.model.error;

import com.google.devtools.common.metrics.stability.model.ErrorIdProvider;
import com.google.devtools.mobileharness.api.model.error.ErrorId;
import javax.annotation.Nullable;

public class MobileHarnessException
extends Exception
implements ErrorIdProvider<ErrorId> {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private final ErrorId errorId;

    public MobileHarnessException(ErrorId errorId, String message) {
        this(errorId, message, null);
    }

    public MobileHarnessException(ErrorId errorId, String message, @Nullable Throwable cause) {
        this(errorId, message, cause, !message.endsWith(MobileHarnessException.getMessageSuffix(errorId)), false);
    }

    MobileHarnessException(ErrorId errorId, String message, @Nullable Throwable cause, boolean addErrorIdToMessage, boolean clearStackTrace) {
        super((String)(addErrorIdToMessage ? message + MobileHarnessException.getMessageSuffix(errorId) : message), cause);
        this.errorId = errorId;
        if (clearStackTrace) {
            this.setStackTrace(EMPTY_STACK_TRACE);
        }
    }

    @Override
    public ErrorId getErrorId() {
        return this.errorId;
    }

    @Override
    public String toString() {
        String classSimpleName = this.getClass().getSimpleName();
        String message = this.getLocalizedMessage();
        return message == null ? classSimpleName : classSimpleName + ": " + message;
    }

    private static String getMessageSuffix(ErrorId errorId) {
        return " " + String.valueOf(errorId);
    }
}

