/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.api.model.error;

import com.google.common.base.Preconditions;
import com.google.devtools.common.metrics.stability.model.proto.ErrorTypeProto;
import com.google.devtools.common.metrics.stability.util.ErrorIdFormatter;
import com.google.devtools.mobileharness.api.model.error.ErrorId;

public enum BasicErrorId implements ErrorId
{
    NON_MH_EXCEPTION(20001, ErrorTypeProto.ErrorType.UNCLASSIFIED),
    JOB_PARAM_VALUE_FORMAT_ERROR(20101, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_PARAM_VALUE_NOT_FOUND(20102, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_TIMEOUT(20103, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_GET_EXPIRE_TIME_ERROR_BEFORE_START(20104, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_TYPE_AND_FIRST_DEVICE_DO_NOT_MATCH(20105, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SET_JOB_SCOPED_SPECS_ERROR_IN_LAB(20106, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_KILLED_BY_USER_FROM_FE(20107, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SUSPENDED_DUE_TO_CONSECUTIVE_FAILURE(20108, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_TYPE_NOT_SUPPORTED(20110, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_INVALID_DEVICE_ERROR(20120, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_GENERIC_ERROR(20121, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_NO_JOB_NAME_ERROR(20123, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_INVALID_JOB_TYPE_ERROR(20124, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_INVALID_RUN_AS_ERROR(20125, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_DEVICE_TARGET_PARSE_ERROR(20126, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_FROM_TEXT_PROTOBUF_ERROR(20127, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_CONFIG_FROM_JSON_ERROR(20128, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_CONFIG_TO_JSON_ERROR(20129, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_CONFIG_MERGE_ERROR(20130, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_SPEC_PARSE_PROTOBUF_ERROR(20131, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SPEC_INVALID_JOB_TYPE_ERROR(20132, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SPEC_INVALID_FILE_PATH_ERROR(20133, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SPEC_PARSE_JSON_ERROR(20134, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SPEC_INVALID_FILE_FIELD_ERROR(20135, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_CONFIG_INVALID_PLUGIN_FILE_PATH_ERROR(20136, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_INFO_CREATE_INVALID_GEN_DIR_ERROR(20151, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_INFO_CREATE_OVERRIDE_INFO_ERROR(20152, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_INFO_CREATE_RESOLVED_DIR_NOT_FOUND_ERROR(20153, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_FAIL_TO_GENERATE_SPONGE_LINK(20161, ErrorTypeProto.ErrorType.UNDETERMINED),
    TEST_TIMEOUT(20201, ErrorTypeProto.ErrorType.UNDETERMINED),
    TEST_GET_EXPIRE_TIME_ERROR_BEFORE_START(20202, ErrorTypeProto.ErrorType.UNDETERMINED),
    TEST_ADD_TEST_GENERATE_DUPLICATED_ID(20203, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    TEST_ADD_TEST_WITH_DUPLICATED_ID(20204, ErrorTypeProto.ErrorType.UNDETERMINED),
    TEST_REMOVE_RUNNING_TEST_ERROR(20205, ErrorTypeProto.ErrorType.UNDETERMINED),
    TEST_RESULT_NOT_FOUND(20206, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_FILE_ADD_NONEXIST_FILE(20301, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_FILE_HANDLER_GENERATE_NO_FILE(20302, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_FILE_HANDLER_ERROR(20303, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_REPLACE_NONEXIST_FILE(20304, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_FILE_NOT_FOUND(20305, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_FILE_MULTI_PATHS(20306, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_FILE_CHECK_ERROR(20307, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_GEN_FILE_DIR_PREPARE_ERROR(20308, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_OR_TEST_RUN_FILE_DIR_PREPARE_ERROR(20309, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_OR_TEST_TMP_FILE_DIR_PREPARE_ERROR(20310, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_OR_TEST_RESULT_LEGACY_FAIL(20311, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_OR_TEST_RESULT_LEGACY_ALLOC_FAIL(20312, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_OR_TEST_RESULT_LEGACY_ERROR(20313, ErrorTypeProto.ErrorType.UNDETERMINED),
    JOB_OR_TEST_RESULT_LEGACY_INFRA_ERROR(20314, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_OR_TEST_RESULT_LEGACY_ALLOC_ERROR(20315, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_OR_TEST_RESULT_LEGACY_ABORT(20316, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    JOB_OR_TEST_RESULT_LEGACY_TIMEOUT(20317, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_OR_TEST_RESULT_LEGACY_SKIP(20318, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TEST_RESULT_FAILED_IN_TEST_XML(20319, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TEST_DOWNLOAD_GEN_DIRECTORY_FROM_LAB_INTERRUPTED(20320, ErrorTypeProto.ErrorType.UNDETERMINED),
    TEST_RESULT_SKIPPED_IN_TEST_XML(20321, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TEST_RESULT_ERRORED_IN_TEST_XML(20322, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    TEST_RESULT_TIMEOUT_IN_TEST_XML(20323, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    MESSAGING_MESSAGE_DESTINATION_NOT_FOUND(20401, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    LOCAL_FILE_OR_DIR_NOT_FOUND(30001, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_COPY_ERROR(30002, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_REMOVE_ERROR(30003, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_CHANGE_GROUP_ERROR(30004, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_CHANGE_OWNER_ERROR(30005, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_GET_SIZE_ERROR(30006, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_PARSE_SIZE_ERROR(30007, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_LINK_ERROR(30008, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_MOVE_ERROR(30009, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_READ_SYMLINK_ERROR(30010, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_GET_REAL_PATH_ERROR(30011, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_OR_DIR_GRANT_PERMISSION_RECURSIVELY_ERROR(30012, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_IS_DIR(30101, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_CREATE_NEW_ERROR(30102, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_APPEND_ERROR(30103, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_GET_OWNER_ERROR(30104, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_GET_PERMISSION_ERROR(30105, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_GRANT_PERMISSION_ERROR(30106, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_GET_MODIFIED_TIME_ERROR(30107, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    LOCAL_FILE_GET_SIZE_ERROR(30108, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_TOO_LARGE_TO_READ(30109, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    LOCAL_FILE_READ_BINARY_ERROR(30110, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_READ_STRING_ERROR(30111, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_READ_HEAD_ERROR(30112, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_READ_TAIL_ERROR(30113, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_READ_LINES_FROM_FILE_SET(30114, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_READ_LINES_FROM_FILE(30115, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_WRITE_STRING_ERROR(30116, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_WRITE_BYTE_ERROR(30117, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_WRITE_STREAM_ERROR(30118, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_WRITE_STREAM_WITH_BUFFER_ERROR(30119, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_WRITE_STREAM_CREATE_BUFFER_ERROR(30120, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_SET_PERMISSION_ERROR(30121, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_RESET_ERROR(30122, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    LOCAL_FILE_UNZIP_ERROR(30123, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_UNZIP_PARTICULAR_FILES_ERROR(30124, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_CREATE_HARD_LINK_ERROR(30125, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_UNZIP_FILENAME_NOT_MATCHED(30126, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    LOCAL_FILE_NEW_BUFFERED_WRITER_ERROR(30127, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_FILE_TAR_EXTRACT_ERROR(30128, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_IS_FILE(30201, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_CREATE_ERROR(30202, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_CREATE_TMP_ERROR(30203, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_LINK_ERROR(30204, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_LINK_ERROR_WITH_RETRY(30205, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_LIST_LINKS_ERROR(30206, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_LIST_DIR_DEPTH_PARAM_ERROR(30207, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_LIST_FILE_PATHS_ERROR(30208, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_LIST_SUB_DIR_ERROR(30209, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_MERGE_ERROR(30210, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_ZIP_ERROR(30211, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_DIR_LIST_FILE_OR_DIRS_ERROR(30212, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_MOUNT_ZIP_TO_DIR_ERROR(30213, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_UNMOUNT_DIR_ERROR(30214, ErrorTypeProto.ErrorType.UNDETERMINED),
    FILE_CHECKSUM_ERROR(30490, ErrorTypeProto.ErrorType.UNDETERMINED),
    LOCAL_NETWORK_ERROR(30501, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    LOCAL_NETWORK_INTERFACE_DETECTION_ERROR(30502, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    LOCAL_NETWORK_HOSTNAME_DETECTION_ERROR(30503, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    MOBILE_HARNESS_LOGGER_CREATE_FILE_HANDLER_ERROR(30601, ErrorTypeProto.ErrorType.UNDETERMINED),
    FILE_UTIL_LOW_DISK_SPACE(30651, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_LAB_HOST_FILESYSTEM_ERROR(30652, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_CREATE_DIR_ERROR(30653, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_READ_STRING_FROM_FILE_ERROR(30654, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_CALCULATE_CRC32_ERROR(30655, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_SAVE_RESOURCE_FILE_ERROR(30656, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_CREATE_TEMP_FILE_ERROR(30657, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_HARDLINK_FILE_ERROR(30658, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_WRITE_TO_FILE_ERROR(30659, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_COPY_FILE_ERROR(30660, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_SYMLINK_FILE_ERROR(30661, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_LIST_FILES_ERROR(30662, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_WALK_FILES_ERROR(30663, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    FILE_UTIL_COMPARE_FILE_CONTENTS_ERROR(30664, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_NO_DISK_SPACE(30851, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_COPY_STREAMS_ERROR(30852, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_SKIP_BYTES_ERROR(30853, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_COPY_FILE_TO_STREAM_ERROR(30854, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_GET_BYTE_ARRAY_LIST_FROM_STREAM_ERROR(30855, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_GET_STRING_FROM_STREAM_ERROR(30856, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_COPY_STREAM_TO_WRITER_ERROR(30857, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_CALCULATE_CRC32_ERROR(30858, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_CLOSE_STREAM_ERROR(30859, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    STREAM_UTIL_CALCULATE_MD5_DIGEST_ERROR(30860, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_ARTIFACT_INVALID(30901, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_CHECK_ZIP_FILE_ERROR(30902, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_GET_INPUT_STREAM_ERROR(30903, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_VALIDATE_DESTINATION_DIR_ERROR(30904, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_CREATE_ZIP_ERROR(30905, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_GZIP_FILE_ERROR(30906, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_LIST_FILES_ERROR(30907, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_ADD_TO_ZIP_ERROR(30908, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_WRITE_TO_STREAM_ERROR(30909, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_SET_POSIX_FILE_PERMISSION_ERROR(30910, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_UNZIP_TO_STREAM_ERROR(30911, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_UNZIP_TO_STREAM_DATA_FORMAT_ERROR(30912, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_CREATE_NEW_FILE_ERROR(30913, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_GET_OUTPUT_STREAM_ERROR(30914, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_CRC_NOT_MATCH_ERROR(30915, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_CREATE_SYMBOLIC_LINK_ERROR(30916, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_UNZIP_SYMLINK_COMPRESSION_METHOD_NOT_SUPPORTED(30917, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_EXTRACT_ZIP_ERROR(30918, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_OPEN_ZIP_FILE_ERROR(30919, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_INVALID_CENTRAL_DIRECTORY_INFO(30920, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ZIP_UTIL_INVALID_LOCAL_FILE_HEADER_ERROR(30921, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    UNEXPECTED_NON_MH_CHECKED_EXCEPTION_FROM_SUB_TASK(31601, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    SYSTEM_NO_PROCESS_FOUND(31651, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_MORE_THAN_ONE_PROCESS_FOUND(31652, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_PROCESS_HEADER_NOT_FOUND(31653, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_INVALID_PROCESS_INFO_LINE(31654, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_INVALID_PROCESS_ID(31655, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_NO_PROCESS_FOUND_BY_PORT(31656, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_INVALID_PROCESS_LIST_ERROR(31657, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_UNEXPECTED_PROCESS_HEADER(31658, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_PARENT_PROCESS_NOT_FOUND(31659, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_KILL_PROCESS_ERROR(31660, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_FAILED_TO_ADD_USER_TO_GROUP(31661, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_FAILED_TO_GET_USER_GROUPS(31662, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_NO_GROUPS_FOR_USER(31663, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_EMPTY_LOGNAME(31664, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_ROOT_ACCESS_REQUIRED(31665, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_USER_HOME_NOT_FOUND(31666, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_NOT_RUN_ON_LINUX_OR_MAC(31667, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_NOT_RUN_ON_LINUX(31668, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_ACCESS_PROC_MEMINFO_ERROR(31669, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    SYSTEM_TAG_NOT_FOUND_IN_PROC_MEMINFO(31670, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_CHECK_KVM_ERROR(31671, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_LIST_OPEN_FILES_ERROR(31672, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_LIST_PROCESSES_ERROR(31673, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_GET_GIVEN_PROCESS_INFO_ERROR(31674, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_KILLALL_PROCESS_ERROR(31675, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_ADD_USER_TO_GROUP_ERROR(31676, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_GET_USER_GROUP_ERROR(31677, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_MAC_LAUNCHCTL_MANAGERUID_ERROR(31678, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_MAC_LAUNCHCTL_LIST_ERROR(31679, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_GET_LOGNAME_ERROR(31680, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_MAC_DSCL_CMD_ERROR(31681, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_GETENT_CMD_ERROR(31682, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_MAC_SYSTEM_PROFILER_ERROR(31683, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_MAC_GET_MEMORY_SIZE_ERROR(31684, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_GET_MAC_DISK_INFO_ERROR(31685, ErrorTypeProto.ErrorType.UNDETERMINED),
    SYSTEM_GET_DISK_TYPE_NON_MAC_UNIMPLEMENTED(31686, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    SYSTEM_PICK_USED_PORT_ERROR(31687, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    REFLECTION_CLASS_NOT_FOUND(31901, ErrorTypeProto.ErrorType.UNDETERMINED),
    REFLECTION_CLASS_TYPE_NOT_MATCHED(31902, ErrorTypeProto.ErrorType.UNDETERMINED),
    REFLECTION_CONSTRUCTOR_NOT_FOUND(31903, ErrorTypeProto.ErrorType.UNDETERMINED),
    REFLECTION_INSTANTIATION_ERROR(31904, ErrorTypeProto.ErrorType.UNDETERMINED),
    REFLECTION_CREATE_DEVICE_CONSTRUCTOR_NOT_FOUND(31905, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    REFLECTION_CREATE_DEVICE_ERROR(31906, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    CLASS_DETECTOR_CLASS_NOT_FOUND(31907, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    CLASS_DEVICE_CLASS_NOT_FOUND(31908, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    CLASS_DRIVER_CLASS_NOT_FOUND(31909, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    CLASS_DECORATOR_CLASS_NOT_FOUND(31910, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    CLASS_STEP_FIELD_ACCESS_ERROR(31911, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    CLASS_ILLEGAL_VALIDATOR_METHOD(31912, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    CLASS_DISPATCHER_CLASS_NOT_FOUND(31913, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    REFLECTION_CLASS_LOAD_ERROR(31914, ErrorTypeProto.ErrorType.UNDETERMINED),
    JAR_RES_NOT_FOUND(32001, ErrorTypeProto.ErrorType.UNDETERMINED),
    JAR_RES_COPY_ERROR(32002, ErrorTypeProto.ErrorType.UNDETERMINED),
    RESOLVE_FILE_GENERIC_ERROR(32251, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RESOLVE_FILE_MISS_NOTEST_LOASD_ERROR(32252, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    RESOLVE_FILE_MISS_PACKAGE_INFO_ERROR(32253, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RESOLVE_FILE_INVALID_FILE_ERROR(32254, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    RESOLVE_FILE_CACHED_EXCEPTION_ERROR(32255, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RESOLVE_FILE_EMPTY_FILE_PATH_ERROR(32256, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    RESOLVE_FILE_TIMEOUT(32300, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_SECURITY_ERROR(32301, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_FILE_NOT_FOUND(32302, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_ILLEGAL_OFFSET(32303, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_ILLEGAL_SIZE(32304, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_NO_DOWNLOADER(32305, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_DOWNLOAD_FILE_ERROR(32306, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_UPLOAD_FILE_ERROR(32307, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_GET_METADATA_ERROR(32308, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_NO_METADATA(32309, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    GCS_LIST_FILES_ERROR(32310, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_DELETE_FILE_ERROR(32311, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_MEET_QUOTA_ISSUE(32312, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_LOAD_CACHE_ERROR(32313, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_SAVE_CACHE_ERROR(32314, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_COMPRESS_DIRECTORY(32315, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    GCS_DOWNLOAD_FILE_NO_SPACE_ERROR(32316, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_INVALID_PARAMS(32317, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    GCS_ILLEGAL_PATH_ERROR(32318, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    GCS_MEET_NETWORK_ISSUE(32319, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    GCS_CLOUD_GAIA_CONNECT_ERROR(32320, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    ATS_FILE_SERVER_RESOLVE_FILE_ERROR(32351, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    HTTP_INVALID_FILE_PATH_ERROR(32352, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    ATS_FILE_SERVER_UPLOAD_FILE_ERROR(32353, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    SSH_CONNECTION_ERROR(32751, ErrorTypeProto.ErrorType.UNDETERMINED),
    SSH_INVALID_PARAMS(32752, ErrorTypeProto.ErrorType.UNDETERMINED),
    SSH_COMMAND_EXECUTION_ERROR(32753, ErrorTypeProto.ErrorType.UNDETERMINED),
    SSH_SFTP_EXECUTION_ERROR(32754, ErrorTypeProto.ErrorType.UNDETERMINED),
    SSH_UPLOAD_DIR_TO_FILE_ERROR(32755, ErrorTypeProto.ErrorType.UNDETERMINED),
    SSH_COMMAND_UNEXPECTED_EXIT_CODE(32757, ErrorTypeProto.ErrorType.UNDETERMINED),
    DHCP_DB_ERROR(32781, ErrorTypeProto.ErrorType.UNDETERMINED),
    BLOBSTORE_BLOBFILE_NOT_EXIST_ERROR(32801, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    BLOBSTORE_READ_BLOB_METADATA_ERROR(32802, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    BLOBSTORE_OPEN_AND_READ_FILE_ERROR(32803, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    BLOBSTORE_FETCH_FILE_ERROR(32804, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    SPONGE_PARSE_XML_ERROR(33005, ErrorTypeProto.ErrorType.UNDETERMINED),
    SPONGE_DOCUMENT_BUILDER_FACTORY_SET_FEATURE_ERROR(33019, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    PLUGIN_LOADER_FAILED_TO_GET_JAR_URL(33101, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    PLUGIN_LOADER_FAILED_TO_CREATE_PLUGIN_MODULE_INSTANCE(33102, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    PLUGIN_LOADER_FAILED_TO_CREATE_PLUGIN_INSTANCE(33103, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    PLUGIN_LOADER_MALFORMED_URL(33104, ErrorTypeProto.ErrorType.UNDETERMINED),
    EXPERIMENT_MANAGER_READ_SOURCE_WITH_TEST_LOAS(33151, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SUSPENDER_CONFIG_FILE_FORMAT_ERROR(33201, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    JOB_SUSPENDER_CONFIG_FILE_READ_ERROR(33202, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    LSPACE_RESOLVE_ERROR(33251, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    LSPACE_ILLEGAL_ARGUMENT(33252, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    LSPACE_ACL_ERROR(33253, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    LSPACE_PERMISSION_DENIED_ERROR(33254, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    LSPACE_CREDENTIAL_NOT_PERMIT_ERROR(33255, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    LSPACE_FAIL_TO_PREPARE_PARENT_DIR(33256, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    API_CONFIG_FILE_READ_ERROR(33351, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    LAB_DEVICE_CONFIG_FILE_READ_ERROR(33352, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    DATABASE_CONNECTIONS_INITIALIZE_ERROR(33401, ErrorTypeProto.ErrorType.UNDETERMINED),
    DATABASE_CONNECTIONS_GET_CONNECTION_ERROR(33402, ErrorTypeProto.ErrorType.UNDETERMINED),
    DATABASE_LIST_TABLES_ERROR(33403, ErrorTypeProto.ErrorType.UNDETERMINED),
    DATABASE_TABLE_UPDATE_ERROR(33404, ErrorTypeProto.ErrorType.UNDETERMINED),
    DATABASE_TABLE_DELETE_ERROR(33405, ErrorTypeProto.ErrorType.UNDETERMINED),
    DATABASE_TABLE_READ_ERROR(33406, ErrorTypeProto.ErrorType.UNDETERMINED),
    DATABASE_TABLE_READ_PROTO_PARSE_ERROR(33407, ErrorTypeProto.ErrorType.UNDETERMINED),
    DATABASE_DRIVER_LOAD_ERROR(33408, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    LEGACY_COMMAND_START_ERROR(33451, ErrorTypeProto.ErrorType.UNDETERMINED),
    LEGACY_COMMAND_EXEC_FAIL(33452, ErrorTypeProto.ErrorType.UNDETERMINED),
    LEGACY_COMMAND_EXEC_TIMEOUT(33453, ErrorTypeProto.ErrorType.UNDETERMINED),
    PERFGATE_ILLEGAL_STATE(33461, ErrorTypeProto.ErrorType.UNDETERMINED),
    PERFGATE_FILE_WRITE_ERROR(33462, ErrorTypeProto.ErrorType.UNDETERMINED),
    URI_ERROR(33471, ErrorTypeProto.ErrorType.UNDETERMINED),
    METADATA_GENERATOR_REFLECTION_CLASS_NOT_FOUND(33521, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    METADATA_GENERATOR_JOB_TAG_ANNOTATION_INVALID(33522, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    DEVICE_INFO_ALREADY_EXIST_ERROR(33581, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    SECRET_MANAGER_ACCESS_SECRET_VERSION_ERROR(33671, ErrorTypeProto.ErrorType.DEPENDENCY_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_DEFAULT(39701, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_CANCELLED(39702, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_UNKNOWN(39703, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_INVALID_ARGUMENT(39704, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_DEADLINE_EXCEEDED(39705, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_NOT_FOUND(39706, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_ALREADY_EXISTS(39707, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_PERMISSION_DENIED(39708, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_RESOURCE_EXHAUSTED(39709, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_FAILED_PRECONDITION(39710, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_ABORTED(39711, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_OUT_OF_RANGE(39712, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_UNIMPLEMENTED(39713, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_INTERNAL(39714, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_UNAVAILABLE(39715, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_STATUS_CODE_UNAUTHENTICATED(39716, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_DEFAULT(39751, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_CANCELLED(39752, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_UNKNOWN(39753, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_INVALID_ARGUMENT(39754, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_DEADLINE_EXCEEDED(39755, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_NOT_FOUND(39756, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_ALREADY_EXISTS(39757, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_PERMISSION_DENIED(39758, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_RESOURCE_EXHAUSTED(39759, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_FAILED_PRECONDITION(39760, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_ABORTED(39761, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_OUT_OF_RANGE(39762, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_UNIMPLEMENTED(39763, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_INTERNAL(39764, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_UNAVAILABLE(39765, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_STATUS_CODE_UNAUTHENTICATED(39766, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_WITHOUT_STATUS_CODE(39961, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_STUBBY_EXCEPTION_WITHOUT_ERROR_DETAIL(39963, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    RPC_GRPC_EXCEPTION_WITHOUT_ERROR_DETAIL(39972, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    EVENT_HANDLER_ERROR(39976, ErrorTypeProto.ErrorType.UNDETERMINED),
    BASE64_ARGUMENT_ERROR(39801, ErrorTypeProto.ErrorType.UNDETERMINED),
    BASE64_ENCODING_ERROR(39802, ErrorTypeProto.ErrorType.UNDETERMINED),
    CACHE_LOAD_ERROR(39811, ErrorTypeProto.ErrorType.UNDETERMINED),
    PROTO_FIELD_NOT_IN_MESSAGE(39821, ErrorTypeProto.ErrorType.UNDETERMINED),
    PROTO_MESSAGE_FIELD_TYPE_UNSUPPORTED(39822, ErrorTypeProto.ErrorType.UNDETERMINED),
    PROTO_FIELD_VALUE_NUMBER_FORMAT_ERROR(39823, ErrorTypeProto.ErrorType.UNDETERMINED),
    FLAG_FORMAT_ERROR(39831, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    PUBSUB_SUBSCRIBER_START_ERROR(39841, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    PUBSUB_SUBSCRIBER_STOP_ERROR(39842, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    FILTER_EMPTY_INPUT(39911, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    FILTER_ILLEGAL_INPUT(39912, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    FILTER_PREDICATE_TYPE_ERROR(39913, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    FILTER_CONDITION_ERROR(39914, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    FILTER_TOKEN_ERROR(39915, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    FILTER_PATTERN_ERROR(39929, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    FILTER_ILLEGAL_STATE(39930, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_SEQUENCE_LENGTH_ERROR(39931, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_NUM_FORMAT_ERROR(39932, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_NUM_RANGE_ERROR(39933, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_SERVICE_FORMAT_ERROR(39934, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_STUB_FORMAT_ERROR(39935, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_SERVICE_TOO_OLD(39936, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_STUB_TOO_OLD(39937, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    VERSION_STUB_GET_VERSION_ERROR(39938, ErrorTypeProto.ErrorType.INFRA_ISSUE),
    USER_PLUGIN_ERROR(39951, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    USER_PLUGIN_SKIP_TEST_OR_JOB(39952, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    INTEGRATION_TEST_ASSERTION_ERROR(39953, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    USER_PLUGIN_SKIP_JOB(39954, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    USER_PLUGIN_SKIP_TEST(39955, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    USER_PLUGIN_SKIP_JOB_BY_INTERRUPTED_EXCEPTION(39956, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    USER_PLUGIN_SKIP_TEST_BY_INTERRUPTED_EXCEPTION(39957, ErrorTypeProto.ErrorType.CUSTOMER_ISSUE),
    COMMAND_START_ERROR(39997, ErrorTypeProto.ErrorType.UNDETERMINED),
    COMMAND_EXEC_FAIL(39998, ErrorTypeProto.ErrorType.UNDETERMINED),
    COMMAND_EXEC_TIMEOUT(39999, ErrorTypeProto.ErrorType.UNDETERMINED),
    COMMAND_CALLBACK_ERROR(40000, ErrorTypeProto.ErrorType.UNDETERMINED);

    public static final int MIN_CODE = 20001;
    public static final int MAX_CODE = 40000;
    private final int code;
    private final ErrorTypeProto.ErrorType type;

    private BasicErrorId(int code, ErrorTypeProto.ErrorType type) {
        Preconditions.checkArgument(code >= 20001);
        Preconditions.checkArgument(code <= 40000);
        Preconditions.checkArgument(code == 20001 || type != ErrorTypeProto.ErrorType.UNCLASSIFIED);
        this.code = code;
        this.type = type;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public ErrorTypeProto.ErrorType type() {
        return this.type;
    }

    public String toString() {
        return ErrorIdFormatter.formatErrorId(this);
    }
}

