/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.rpc.grpc;

import com.google.devtools.common.metrics.stability.model.ErrorId;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionUtil;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.StatusRuntimeException;

public final class GrpcStubUtil {
    private GrpcStubUtil() {
    }

    @CanIgnoreReturnValue
    public static <ReqT, RespT> RespT invoke(GrpcMethod<ReqT, RespT> grpcMethod, ReqT request, ErrorId errorId, String errorMessage) throws GrpcExceptionWithErrorId {
        try {
            return grpcMethod.execute(request);
        }
        catch (StatusRuntimeException e) {
            throw GrpcExceptionUtil.toGrpcExceptionWithErrorId(errorId, errorMessage, e);
        }
    }

    @FunctionalInterface
    public static interface GrpcMethod<ReqT, RespT> {
        public RespT execute(ReqT var1) throws StatusRuntimeException;
    }
}

