/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.metrics.stability.rpc.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.common.metrics.stability.converter.DeserializedException;
import com.google.devtools.common.metrics.stability.converter.ErrorModelConverter;
import com.google.devtools.common.metrics.stability.model.ErrorId;
import com.google.devtools.common.metrics.stability.rpc.RpcErrorUtil;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.common.metrics.stability.rpc.proto.RpcErrorPayloadProto;
import com.google.devtools.common.metrics.stability.rpc.proto.RpcErrorProto;
import com.google.devtools.mobileharness.shared.util.base.ProtoExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;

public class GrpcExceptionUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    @VisibleForTesting
    static final int EXCEPTION_DETAIL_SIZE_LIMIT_BYTES = 3072;

    public static StatusRuntimeException toStatusRuntimeException(Throwable throwable) {
        Metadata trailers = new Metadata();
        GrpcExceptionUtil.addMessageToMetadata(trailers, RpcErrorPayloadProto.RpcErrorPayload.newBuilder().setRpcError(RpcErrorUtil.toRpcError(ErrorModelConverter.toExceptionDetail(throwable), 3072)).build());
        return Status.INTERNAL.withDescription(throwable.getMessage()).asRuntimeException(trailers);
    }

    public static GrpcExceptionWithErrorId toGrpcExceptionWithErrorId(ErrorId errorId, String message, StatusRuntimeException grpcException) {
        DeserializedException applicationError = null;
        IOException deserializingError = null;
        try {
            applicationError = GrpcExceptionUtil.getApplicationError(grpcException).orElse(null);
        }
        catch (IOException e) {
            deserializingError = e;
        }
        GrpcExceptionWithErrorId result = new GrpcExceptionWithErrorId(errorId, message, grpcException.getStatus().getCode().value(), applicationError, grpcException);
        if (deserializingError != null) {
            result.addSuppressed(deserializingError);
        }
        return result;
    }

    private static Optional<DeserializedException> getApplicationError(Throwable throwable) throws IOException {
        Optional<RpcErrorProto.RpcError> error = GrpcExceptionUtil.getPayload(throwable).filter(RpcErrorPayloadProto.RpcErrorPayload::hasRpcError).map(RpcErrorPayloadProto.RpcErrorPayload::getRpcError);
        return error.isPresent() ? RpcErrorUtil.toExceptionDetail(error.get()).map(ErrorModelConverter::toDeserializedException) : Optional.empty();
    }

    public static Optional<RpcErrorPayloadProto.RpcErrorPayload> getPayload(Throwable throwable) {
        for (Throwable cause = Preconditions.checkNotNull(throwable, "throwable cannot be null"); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusRuntimeException) {
                StatusRuntimeException e = (StatusRuntimeException)cause;
                return GrpcExceptionUtil.getPayload(e.getStatus(), e.getTrailers(), e);
            }
            if (!(cause instanceof StatusException)) continue;
            StatusException e = (StatusException)cause;
            return GrpcExceptionUtil.getPayload(e.getStatus(), e.getTrailers(), e);
        }
        return Optional.empty();
    }

    private static Optional<RpcErrorPayloadProto.RpcErrorPayload> getPayload(Status status, Metadata trailers, Throwable cause) {
        return Stream.of(GrpcExceptionUtil.getPayloadFromProto(trailers), GrpcExceptionUtil.getPayloadFromBinary(trailers, cause)).filter(Optional::isPresent).flatMap(Optional::stream).findFirst();
    }

    private static Optional<RpcErrorPayloadProto.RpcErrorPayload> getPayloadFromProto(Metadata trailers) {
        return Optional.ofNullable(trailers.get(ProtoUtils.keyForProto(RpcErrorPayloadProto.RpcErrorPayload.getDefaultInstance())));
    }

    private static Optional<RpcErrorPayloadProto.RpcErrorPayload> getPayloadFromBinary(Metadata trailers, Throwable cause) {
        byte[] bytes = trailers.get(Metadata.Key.of(String.format("__crpc_mse_%d%s", 300713958, "-bin"), Metadata.BINARY_BYTE_MARSHALLER));
        if (bytes == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(RpcErrorPayloadProto.RpcErrorPayload.parseFrom(bytes, (ExtensionRegistryLite)ProtoExtensionRegistry.getGeneratedRegistry()));
        }
        catch (InvalidProtocolBufferException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(cause)).log("Failed to parse payload from %s trailers: %s", (Object)cause.getClass().getSimpleName(), (Object)trailers);
            return Optional.empty();
        }
    }

    private static void addMessageToMetadata(Metadata metadata, Message message) {
        Metadata.Key<byte[]> key = Metadata.Key.of(String.format("%s%d%s", "__crpc_mse_", 300713958, "-bin"), Metadata.BINARY_BYTE_MARSHALLER);
        metadata.put(key, message.toByteArray());
    }

    private GrpcExceptionUtil() {
    }
}

